/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.NotificationService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NotificationServiceImpl
implements NotificationService {
    private final HuskyPlugin plugin;
    private final ConfigService configService;
    private final Map<UUID, BossBar> bossBarMap = new ConcurrentHashMap<UUID, BossBar>();

    public NotificationServiceImpl(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.configService = plugin.provide(ConfigService.class);
    }

    @Override
    public void sendTrust(Player player, String name, String description) {
        String capitalizedChunk = Util.capitalize(name);
        Config config = this.configService.getConfig();
        switch (config.getNotificationType()) {
            case TITLE: {
                String header = Locale.NOTIFICATION_TITLE_HEADER.parameterize(ChatColor.YELLOW, capitalizedChunk);
                String footer = Locale.NOTIFICATION_TITLE_FOOTER.parameterize(description);
                this.sendTitle(player, header, footer);
                break;
            }
            case BOSS_BAR: {
                String message = Locale.NOTIFICATION_BOSS_BAR.parameterize(ChatColor.YELLOW, capitalizedChunk);
                this.sendBossBar(player, BarColor.YELLOW, message);
                break;
            }
            case ACTION_BAR: {
                String message = Locale.NOTIFICATION_ACTION_BAR.parameterize(ChatColor.YELLOW, capitalizedChunk);
                this.sendActionBar(player, message);
            }
        }
    }

    @Override
    public void sendWilderness(Player player) {
        Config config = this.configService.getConfig();
        switch (config.getNotificationType()) {
            case TITLE: {
                String header = Locale.NOTIFICATION_WILDERNESS_TITLE_HEADER.parse();
                String footer = Locale.NOTIFICATION_WILDERNESS_TITLE_FOOTER.parse();
                this.sendTitle(player, header, footer);
                break;
            }
            case BOSS_BAR: {
                String title = Locale.NOTIFICATION_WILDERNESS_BOSS_BAR.parse();
                this.sendBossBar(player, BarColor.GREEN, title);
                break;
            }
            case ACTION_BAR: {
                String title = Locale.NOTIFICATION_WILDERNESS_ACTION_BAR.parse();
                this.sendActionBar(player, title);
            }
        }
    }

    @Override
    public void sendSettlement(Player player, String chunk, String description, boolean isClaim) {
        BarColor barColor = isClaim ? BarColor.BLUE : BarColor.RED;
        ChatColor chatColor = isClaim ? ChatColor.AQUA : ChatColor.RED;
        String capitalizedChunk = Util.capitalize(chunk);
        Config config = this.configService.getConfig();
        switch (config.getNotificationType()) {
            case TITLE: {
                String header = Locale.NOTIFICATION_TITLE_HEADER.parameterize(chatColor, capitalizedChunk);
                String footer = Locale.NOTIFICATION_TITLE_FOOTER.parameterize(description);
                this.sendTitle(player, header, footer);
                break;
            }
            case BOSS_BAR: {
                String message = Locale.NOTIFICATION_BOSS_BAR.parameterize(chatColor, capitalizedChunk);
                this.sendBossBar(player, barColor, message);
                break;
            }
            case ACTION_BAR: {
                String message = Locale.NOTIFICATION_ACTION_BAR.parameterize(chatColor, capitalizedChunk);
                this.sendActionBar(player, message);
            }
        }
    }

    private void sendActionBar(Player player, String string) {
        if (this.bossBarMap.containsKey(player.getUniqueId())) {
            this.bossBarMap.get(player.getUniqueId()).removePlayer(player);
            this.bossBarMap.remove(player.getUniqueId());
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)string));
    }

    private void sendTitle(Player player, String header, String footer) {
        if (this.bossBarMap.containsKey(player.getUniqueId())) {
            this.bossBarMap.get(player.getUniqueId()).removePlayer(player);
            this.bossBarMap.remove(player.getUniqueId());
        }
        player.sendTitle(header, footer, 20, 40, 20);
    }

    private void sendBossBar(final Player player, BarColor color, String message) {
        Bukkit.getBossBars().forEachRemaining(keyedBossBar -> player.sendMessage(keyedBossBar.getKey().getKey()));
        if (this.bossBarMap.containsKey(player.getUniqueId())) {
            this.bossBarMap.get(player.getUniqueId()).removePlayer(player);
            this.bossBarMap.remove(player.getUniqueId());
        }
        final BossBar bossBar = Bukkit.createBossBar((String)message, (BarColor)color, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        new BukkitRunnable(){
            double countdown = 40.0;

            public void run() {
                BossBar fromMap;
                if (NotificationServiceImpl.this.bossBarMap.containsKey(player.getUniqueId()) && (fromMap = NotificationServiceImpl.this.bossBarMap.get(player.getUniqueId())) != bossBar) {
                    bossBar.removePlayer(player);
                    this.cancel();
                    return;
                }
                if (this.countdown <= 0.0) {
                    NotificationServiceImpl.this.bossBarMap.get(player.getUniqueId()).removePlayer(player);
                    NotificationServiceImpl.this.bossBarMap.remove(player.getUniqueId());
                    this.cancel();
                } else {
                    this.countdown -= 1.0;
                    bossBar.setProgress(this.countdown / 40.0);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.bossBarMap.put(player.getUniqueId(), bossBar);
    }
}

