/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.google.gson.reflect.TypeToken;
import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class MemberServiceImpl
implements MemberService {
    private Map<UUID, Member> members = new ConcurrentHashMap<UUID, Member>();

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "data/members", this.members);
        plugin.getLogger().info("Saved " + this.members.size() + " members(s).");
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        int size;
        Type type = new TypeToken<Map<UUID, Member>>(){}.getType();
        this.members = (Map)Json.read((Plugin)plugin, "data/members", type);
        if (this.members == null) {
            this.members = new ConcurrentHashMap<UUID, Member>();
        }
        if ((size = this.members.size()) > 0) {
            plugin.getLogger().info("Registered " + size + " members(s).");
        }
    }

    @Override
    public boolean hasSettlement(OfflinePlayer offlinePlayer) {
        return this.members.containsKey(offlinePlayer.getUniqueId());
    }

    @Override
    public void add(OfflinePlayer offlinePlayer, String name, String defaultRole) {
        this.members.put(offlinePlayer.getUniqueId(), Member.create(name, defaultRole));
    }

    @Override
    public void remove(OfflinePlayer offlinePlayer) {
        this.members.remove(offlinePlayer.getUniqueId());
    }

    @Override
    public void clean(String settlementName) {
        this.members.values().removeIf(member -> member.getSettlement().equalsIgnoreCase(settlementName));
    }

    @Override
    public int getCount() {
        return this.members.size();
    }

    @Override
    public Member getCitizen(OfflinePlayer offlinePlayer) {
        return this.members.get(offlinePlayer.getUniqueId());
    }

    @Override
    public List<Member> getMembers(String settlementName) {
        return this.members.values().stream().filter(member -> member.getSettlement().equalsIgnoreCase(settlementName)).collect(Collectors.toList());
    }

    @Override
    public LinkedHashMap<String, Long> getTop(int limit) {
        return this.members.values().stream().collect(Collectors.groupingBy(Member::getSettlement, Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @Override
    public List<OfflinePlayer> getOfflinePlayers(String settlementName) {
        return this.members.entrySet().stream().filter(entry -> ((Member)entry.getValue()).getSettlement().equalsIgnoreCase(settlementName)).map(entry -> Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()))).collect(Collectors.toList());
    }

    @Override
    public void sync(String settlementName, String defaultRole, Role role) {
        for (Member member : this.getMembers(settlementName)) {
            if (!member.getRole().equalsIgnoreCase(role.getName())) continue;
            member.setRole(defaultRole);
        }
    }
}

