/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import com.huskydreaming.huskycore.inventories.InventoryModuleProvider;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.enumeration.Flag;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.filters.MemberFilter;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.inventories.base.InventoryAction;
import com.huskydreaming.settlements.inventories.base.InventoryActionType;
import com.huskydreaming.settlements.inventories.modules.admin.AdminDefaultsModule;
import com.huskydreaming.settlements.inventories.modules.admin.AdminDisabledWorldsModule;
import com.huskydreaming.settlements.inventories.modules.admin.AdminNotificationModule;
import com.huskydreaming.settlements.inventories.modules.admin.AdminTrustingModule;
import com.huskydreaming.settlements.inventories.modules.general.ClaimModule;
import com.huskydreaming.settlements.inventories.modules.general.FlagModule;
import com.huskydreaming.settlements.inventories.modules.general.HomeModule;
import com.huskydreaming.settlements.inventories.modules.general.InformationModule;
import com.huskydreaming.settlements.inventories.modules.general.MembersModule;
import com.huskydreaming.settlements.inventories.modules.general.RoleModule;
import com.huskydreaming.settlements.inventories.modules.general.SpawnModule;
import com.huskydreaming.settlements.inventories.providers.ClaimsInventory;
import com.huskydreaming.settlements.inventories.providers.ConfirmationInventory;
import com.huskydreaming.settlements.inventories.providers.DefaultsInventory;
import com.huskydreaming.settlements.inventories.providers.FlagsInventory;
import com.huskydreaming.settlements.inventories.providers.HomesInventory;
import com.huskydreaming.settlements.inventories.providers.MemberInventory;
import com.huskydreaming.settlements.inventories.providers.MembersInventory;
import com.huskydreaming.settlements.inventories.providers.RoleInventory;
import com.huskydreaming.settlements.inventories.providers.RolesInventory;
import com.huskydreaming.settlements.inventories.providers.SettlementInventory;
import com.huskydreaming.settlements.inventories.providers.SettlementsInventory;
import com.huskydreaming.settlements.inventories.providers.WorldsInventory;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.HomeService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Home;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import fr.minuskube.inv.InventoryManager;
import fr.minuskube.inv.SmartInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class InventoryServiceImpl
implements InventoryService {
    private InventoryManager manager;
    private final ClaimService claimService;
    private final ConfigService configService;
    private final HomeService homeService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final TrustService trustService;
    private final Map<UUID, InventoryAction> actions = new ConcurrentHashMap<UUID, InventoryAction>();

    public InventoryServiceImpl(HuskyPlugin plugin) {
        this.claimService = plugin.provide(ClaimService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.homeService = plugin.provide(HomeService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.trustService = plugin.provide(TrustService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        this.manager = new InventoryManager(plugin);
        this.manager.init();
    }

    @Override
    public void addAction(Player player, InventoryAction action) {
        this.actions.put(player.getUniqueId(), action);
    }

    @Override
    public void acceptAction(Player player) {
        this.actions.get(player.getUniqueId()).onAccept(player);
        this.actions.remove(player.getUniqueId());
    }

    @Override
    public void denyAction(Player player) {
        this.actions.get(player.getUniqueId()).onDeny(player);
        this.actions.remove(player.getUniqueId());
    }

    @Override
    public InventoryActionType getActionType(Player player) {
        return this.actions.get(player.getUniqueId()).getType();
    }

    @Override
    public SmartInventory getAdminInventory(Player player, HuskyPlugin plugin) {
        InventoryModuleProvider adminInventory = new InventoryModuleProvider();
        adminInventory.deserialize(player, new AdminDefaultsModule(plugin), new AdminDisabledWorldsModule(plugin), new AdminNotificationModule(plugin), new AdminTrustingModule(plugin), new AdminTrustingModule(plugin));
        return SmartInventory.builder().manager(this.manager).id("adminInventory").size(Math.min(adminInventory.getRows() + 2, 5), 9).provider(adminInventory).title("Admin Panel").build();
    }

    @Override
    public SmartInventory getWorldsInventory(HuskyPlugin plugin) {
        List<String> worlds = Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
        String[] disabledWorlds = worlds.toArray(new String[0]);
        int rows = (int)Math.ceil((double)disabledWorlds.length / 9.0);
        WorldsInventory worldsInventory = new WorldsInventory(plugin, rows);
        worldsInventory.setArray(disabledWorlds);
        return SmartInventory.builder().manager(this.manager).id("worldsInventory").size(Math.min(rows + 2, 5), 9).provider(worldsInventory).title("Worlds").build();
    }

    @Override
    public SmartInventory getRoleInventory(HuskyPlugin plugin, Player player, Role role) {
        RolePermission[] rolePermissions = RolePermission.values();
        RolePermission[] permissions = Arrays.copyOfRange(rolePermissions, 1, rolePermissions.length);
        int rows = (int)Math.ceil((double)permissions.length / 9.0);
        RoleInventory roleInventory = new RoleInventory(plugin, rows, role, permissions);
        return SmartInventory.builder().manager(this.manager).id("roleInventory").size(Math.min(rows + 2, 5), 9).provider(roleInventory).title("Editing: " + Util.capitalize(role.getName())).build();
    }

    @Override
    public SmartInventory getMainInventory(HuskyPlugin plugin, Player player) {
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Config config = this.configService.getConfig();
        SettlementInventory settlementInventory = new SettlementInventory(plugin);
        ArrayList<InventoryModule> modules = new ArrayList<InventoryModule>();
        modules.add(new MembersModule(plugin));
        modules.add(new ClaimModule(plugin));
        modules.add(new RoleModule(plugin));
        modules.add(new InformationModule(plugin));
        modules.add(new FlagModule(plugin));
        if (config.isHomes() && this.homeService.hasHomes(member.getSettlement()) && !this.homeService.getHomes(member.getSettlement()).isEmpty()) {
            modules.add(new HomeModule(plugin));
        }
        if (config.isTeleportation()) {
            modules.add(new SpawnModule(plugin));
        }
        settlementInventory.deserialize(player, modules);
        return SmartInventory.builder().id("settlementInventory").manager(this.manager).size(Math.min(settlementInventory.getRows() + 2, 5), 9).provider(settlementInventory).title("Editing: " + Util.capitalize(member.getSettlement())).build();
    }

    @Override
    public SmartInventory getSettlementsInventory(HuskyPlugin plugin) {
        String[] settlements = this.settlementService.getSettlements().keySet().toArray(new String[0]);
        int rows = (int)Math.ceil((double)settlements.length / 9.0);
        SettlementsInventory settlementsInventory = new SettlementsInventory(plugin, rows, settlements);
        return SmartInventory.builder().manager(this.manager).id("settlementsInventory").size(Math.min(rows + 2, 5), 9).provider(settlementsInventory).title("Settlements").build();
    }

    @Override
    public SmartInventory getConfirmationInventory(HuskyPlugin plugin, Player player) {
        ConfirmationInventory confirmationInventory = new ConfirmationInventory(plugin);
        return SmartInventory.builder().manager(this.manager).id("confirmationInventory").size(3, 9).provider(confirmationInventory).title(this.getActionType(player).getTitle()).build();
    }

    @Override
    public SmartInventory getRolesInventory(HuskyPlugin plugin, Player player) {
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        List<Role> roles = this.roleService.getRoles(member.getSettlement());
        Role[] array = roles.toArray(new Role[0]);
        int rows = (int)Math.ceil((double)array.length / 9.0);
        RolesInventory rolesInventory = new RolesInventory(plugin, rows, array);
        return SmartInventory.builder().manager(this.manager).id("rolesInventory").size(Math.min(rows + 2, 5), 9).provider(rolesInventory).title("Roles").build();
    }

    @Override
    public SmartInventory getHomesInventory(HuskyPlugin plugin, Player player) {
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        ArrayList<Object> homes = new ArrayList<Home>();
        if (this.homeService.hasHomes(member.getSettlement())) {
            homes = new ArrayList<Home>(this.homeService.getHomes(member.getSettlement()));
        }
        homes.add(0, Home.create("spawn", Material.ENDER_PEARL, settlement.getLocation()));
        Home[] finalHomes = homes.toArray(new Home[0]);
        int rows = (int)Math.ceil((double)finalHomes.length / 9.0);
        HomesInventory homesInventory = new HomesInventory(plugin, rows);
        homesInventory.setArray(finalHomes);
        return SmartInventory.builder().manager(this.manager).id("homesInventory").size(Math.min(rows + 2, 5), 9).provider(homesInventory).title("Homes").build();
    }

    @Override
    public SmartInventory getFlagsInventory(HuskyPlugin plugin, Player player) {
        Flag[] flags = Flag.values();
        int rows = (int)Math.ceil((double)flags.length / 9.0);
        FlagsInventory flagsInventory = new FlagsInventory(plugin, rows, flags);
        return SmartInventory.builder().manager(this.manager).id("flagsInventory").size(Math.min(rows + 2, 5), 9).provider(flagsInventory).title("Flags").build();
    }

    @Override
    public SmartInventory getClaimsInventory(HuskyPlugin plugin, Player player) {
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        ChunkData[] chunks = this.claimService.getClaims(member.getSettlement()).toArray(new ChunkData[0]);
        int rows = (int)Math.ceil((double)chunks.length / 9.0);
        ClaimsInventory claimsInventory = new ClaimsInventory(plugin, rows, chunks);
        return SmartInventory.builder().manager(this.manager).id("claimsInventory").size(Math.min(rows + 2, 5), 9).provider(claimsInventory).title("Claims").build();
    }

    @Override
    public SmartInventory getSettlementDefaultsInventory(HuskyPlugin plugin) {
        SettlementDefaultType[] types = SettlementDefaultType.values();
        int rows = (int)Math.ceil((double)types.length / 9.0);
        DefaultsInventory defaultsInventory = new DefaultsInventory(plugin, rows);
        defaultsInventory.setArray(types);
        return SmartInventory.builder().manager(this.manager).id("defaultsInventory").size(Math.min(rows + 2, 5), 9).provider(defaultsInventory).title("Defaults").build();
    }

    @Override
    public SmartInventory getMembersInventory(HuskyPlugin plugin, Player player, MemberFilter memberFilter) {
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        List<Object> trustedOfflinePlayers = new ArrayList();
        Config config = this.configService.getConfig();
        if (config.isTrusting()) {
            trustedOfflinePlayers = this.trustService.getOfflinePlayers(member.getSettlement());
        }
        List<OfflinePlayer> memberOfflinePlayers = this.memberService.getOfflinePlayers(member.getSettlement());
        List<OfflinePlayer> offlinePlayers = switch (memberFilter) {
            default -> throw new IncompatibleClassChangeError();
            case MemberFilter.ALL -> Stream.concat(trustedOfflinePlayers.stream(), memberOfflinePlayers.stream()).toList();
            case MemberFilter.MEMBER -> memberOfflinePlayers;
            case MemberFilter.TRUSTED -> trustedOfflinePlayers;
        };
        int rows = (int)Math.ceil((double)offlinePlayers.size() / 9.0);
        OfflinePlayer[] array = offlinePlayers.toArray(new OfflinePlayer[0]);
        MembersInventory membersInventory = new MembersInventory(plugin, rows, array);
        membersInventory.setMemberFilter(memberFilter);
        return SmartInventory.builder().manager(this.manager).id("membersInventory").size(Math.min(rows + 2, 5), 9).provider(membersInventory).title("Members").build();
    }

    @Override
    public SmartInventory getMemberInventory(HuskyPlugin plugin, OfflinePlayer offlinePlayer) {
        MemberInventory memberInventory = new MemberInventory(plugin, offlinePlayer);
        return SmartInventory.builder().manager(this.manager).id("memberInventory").size(3, 9).provider(memberInventory).title("Editing: " + Util.capitalize(offlinePlayer.getName())).build();
    }
}

