/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.google.common.reflect.TypeToken;
import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.settlements.services.interfaces.HomeService;
import com.huskydreaming.settlements.storage.persistence.Home;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HomeServiceImpl
implements HomeService {
    private Map<String, List<Home>> homes;

    @Override
    public void deserialize(HuskyPlugin plugin) {
        Type type = new TypeToken<Map<String, List<Home>>>(){}.getType();
        this.homes = (Map)Json.read((Plugin)plugin, "data/homes", type);
        if (this.homes == null) {
            this.homes = new ConcurrentHashMap<String, List<Home>>();
        }
    }

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "data/homes", this.homes);
    }

    @Override
    public void setHome(String settlement, String name, Player player) {
        this.homes.computeIfAbsent(settlement, s -> new ArrayList()).add(Home.create(name, player.getLocation()));
    }

    @Override
    public void deleteHome(String settlement, String name) {
        this.homes.get(settlement).removeIf(home -> home.name().equalsIgnoreCase(name));
    }

    @Override
    public boolean hasHome(String settlement, String name) {
        return this.homes.containsKey(settlement) && this.homes.get(settlement).stream().anyMatch(home -> home.name().equalsIgnoreCase(name));
    }

    @Override
    public boolean hasHomes(String settlement) {
        return this.homes.containsKey(settlement);
    }

    @Override
    public Home getHome(String settlement, String name) {
        return this.homes.get(settlement).stream().filter(home -> home.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public List<Home> getHomes(String settlement) {
        if (!this.homes.containsKey(settlement)) {
            return new ArrayList<Home>();
        }
        return Collections.unmodifiableList(this.homes.get(settlement));
    }
}

