/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.google.common.reflect.TypeToken;
import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.settlements.enumeration.Flag;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;

public class FlagServiceImpl
implements FlagService {
    private Map<String, Set<Flag>> flags;
    private final ConfigService configService;

    public FlagServiceImpl(HuskyPlugin plugin) {
        this.configService = plugin.provide(ConfigService.class);
    }

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "data/flags", this.flags);
        plugin.getLogger().info("Saved " + this.flags.size() + " flags(s).");
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        int size;
        Type type = new TypeToken<Map<String, Set<Flag>>>(){}.getType();
        this.flags = (Map)Json.read((Plugin)plugin, "data/flags", type);
        if (this.flags == null) {
            this.flags = new ConcurrentHashMap<String, Set<Flag>>();
        }
        if ((size = this.flags.size()) > 0) {
            plugin.getLogger().info("Registered " + size + " settlement flags(s).");
        }
    }

    @Override
    public void clean(String string) {
        this.flags.remove(string);
    }

    @Override
    public void setup(String string) {
        HashSet<Flag> flagSet = new HashSet<Flag>(this.configService.getConfig().getFlags());
        this.flags.put(string, flagSet);
    }

    @Override
    public void addFlag(String string, Flag flag) {
        if (this.flags.containsKey(string)) {
            this.flags.get(string).add(flag);
        } else {
            HashSet<Flag> flags = new HashSet<Flag>();
            flags.add(flag);
            this.flags.put(string, flags);
        }
    }

    @Override
    public void removeFlag(String string, Flag flag) {
        if (this.flags.containsKey(string)) {
            this.flags.get(string).remove((Object)flag);
        } else {
            HashSet flags = new HashSet();
            this.flags.put(string, flags);
        }
    }

    @Override
    public boolean hasFlag(String string, Flag flag) {
        if (this.flags.containsKey(string)) {
            return this.flags.get(string).contains((Object)flag);
        }
        HashSet flags = new HashSet();
        this.flags.put(string, flags);
        return false;
    }
}

