/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.settlements.enumeration.Flag;
import com.huskydreaming.settlements.enumeration.RoleDefault;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.types.NotificationType;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConfigServiceImpl
implements ConfigService {
    private Config config;

    public ConfigServiceImpl(HuskyPlugin plugin) {
        this.setupConfig(plugin);
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        this.setupConfig(plugin);
    }

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "config", this.config);
    }

    @Override
    public boolean isDisabledWorld(Player player) {
        World world = player.getWorld();
        if (this.config.containsDisableWorld(world) || world.getEnvironment() != World.Environment.NORMAL) {
            player.sendMessage(Locale.SETTLEMENT_LAND_DISABLED_WORLD.prefix(new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    private void setupConfig(HuskyPlugin plugin) {
        this.config = (Config)Json.read((Plugin)plugin, "config", Config.class);
        if (this.config != null) {
            return;
        }
        this.config = new Config();
        this.config.setFlags(List.of(Flag.ANIMAL_SPAWNING, Flag.MONSTER_SPAWNING));
        this.config.setNotificationType(NotificationType.TITLE);
        this.config.setDisabledWorlds(List.of("world_nether", "world_the_end"));
        this.config.setEmptyPlaceholder("-");
        this.config.setTeleportation(true);
        this.config.setHomes(true);
        this.config.setTrusting(true);
        ConcurrentHashMap<SettlementDefaultType, Integer> settlementsDefaults = new ConcurrentHashMap<SettlementDefaultType, Integer>();
        for (SettlementDefaultType settlementDefaultType : SettlementDefaultType.values()) {
            settlementsDefaults.put(settlementDefaultType, settlementDefaultType.getValue());
        }
        this.config.setSettlementDefaults(settlementsDefaults);
        HashMap<String, List<RolePermission>> roleDefaults = new HashMap<String, List<RolePermission>>();
        for (RoleDefault roleDefault : RoleDefault.values()) {
            roleDefaults.put(roleDefault.toString(), roleDefault.getRolePermissions());
        }
        this.config.setDefaultRoles(roleDefaults);
        Json.write((Plugin)plugin, "config", this.config);
    }
}

