/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.google.common.reflect.TypeToken;
import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.huskycore.storage.Json;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;

public class ClaimServiceImpl
implements ClaimService {
    private Map<ChunkData, String> chunks;

    @Override
    public void serialize(HuskyPlugin plugin) {
        Json.write((Plugin)plugin, "data/claims", this.chunks);
        plugin.getLogger().info("Saved " + this.chunks.size() + " claim(s).");
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        int size;
        Type type = new TypeToken<Map<ChunkData, String>>(){}.getType();
        this.chunks = (Map)Json.read((Plugin)plugin, "data/claims", type);
        if (this.chunks == null) {
            this.chunks = new ConcurrentHashMap<ChunkData, String>();
        }
        if ((size = this.chunks.size()) > 0) {
            plugin.getLogger().info("Registered " + size + " claim(s).");
        }
    }

    @Override
    public void setClaim(Chunk chunk, String name) {
        this.chunks.put(ChunkData.deserialize(chunk), name);
    }

    @Override
    public void removeClaim(Chunk chunk) {
        this.chunks.remove(ChunkData.deserialize(chunk));
    }

    @Override
    public void clean(String name) {
        this.getClaims(name).forEach(claim -> this.chunks.remove(claim));
    }

    @Override
    public boolean isClaim(Chunk chunk) {
        return this.chunks.containsKey(ChunkData.deserialize(chunk));
    }

    @Override
    public String getClaim(Chunk chunk) {
        return this.chunks.get(ChunkData.deserialize(chunk));
    }

    @Override
    public int getCount() {
        return this.chunks.size();
    }

    @Override
    public LinkedHashMap<String, Long> getTop(int limit) {
        return this.chunks.values().stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @Override
    public Set<ChunkData> getClaims(String name) {
        HashSet<ChunkData> claims = new HashSet<ChunkData>();
        for (Map.Entry<ChunkData, String> entry : this.chunks.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(name)) continue;
            claims.add(entry.getKey());
        }
        return claims;
    }

    @Override
    public boolean isAdjacent(String name, Chunk chunk) {
        boolean adjacent = false;
        for (ChunkData data : this.getClaims(name)) {
            if (!Util.areAdjacentChunks(chunk, data.toChunk())) continue;
            adjacent = true;
        }
        return adjacent;
    }

    @Override
    public boolean isAdjacentToOtherClaim(String string, Chunk chunk) {
        World world = chunk.getWorld();
        boolean adjacent = false;
        for (BlockFace blockFace : Util.chunkSteps) {
            String claim;
            int modX = blockFace.getModX();
            int modZ = blockFace.getModZ();
            Chunk adjacentChunk = world.getChunkAt(chunk.getX() + modX, chunk.getZ() + modZ);
            if (!this.isClaim(adjacentChunk) || (claim = this.getClaim(adjacentChunk)).equalsIgnoreCase(string)) continue;
            adjacent = true;
        }
        return adjacent;
    }

    @Override
    public boolean isAdjacentToExistingClaim(Chunk chunk) {
        World world = chunk.getWorld();
        boolean adjacent = false;
        for (BlockFace blockFace : Util.chunkSteps) {
            int modX = blockFace.getModX();
            int modZ = blockFace.getModZ();
            Chunk adjacentChunk = world.getChunkAt(chunk.getX() + modX, chunk.getZ() + modZ);
            if (!this.isClaim(adjacentChunk)) continue;
            adjacent = true;
        }
        return adjacent;
    }
}

