/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.services.implementations;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.storage.transience.BorderData;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BorderServiceImpl
implements BorderService {
    private final ClaimService claimService;
    private final Map<Player, BorderData> borders = new ConcurrentHashMap<Player, BorderData>();

    public BorderServiceImpl(HuskyPlugin plugin) {
        this.claimService = plugin.provide(ClaimService.class);
    }

    @Override
    public void deserialize(HuskyPlugin plugin) {
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry<Player, BorderData> entry : BorderServiceImpl.this.borders.entrySet()) {
                    Player player = entry.getKey();
                    BorderData borderData = entry.getValue();
                    Particle.DustOptions dustOptions = new Particle.DustOptions(borderData.color(), 1.0f);
                    for (Location location : borderData.locations()) {
                        player.spawnParticle(Particle.REDSTONE, location, 1, (Object)dustOptions);
                    }
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 6L);
    }

    @Override
    public void addPlayer(Player player, String name, Color color) {
        this.borders.put(player, this.calculatePositions(name, color));
    }

    @Override
    public void removePlayer(Player player) {
        this.borders.remove(player);
    }

    @Override
    public BorderData calculatePositions(String name, Color color) {
        HashSet<Location> points = new HashSet<Location>();
        for (ChunkData data : this.claimService.getClaims(name)) {
            int z;
            int x;
            Chunk chunk = data.toChunk();
            World world = chunk.getWorld();
            int minX = data.getX() << 4;
            int minZ = data.getZ() << 4;
            int maxX = minX + 16;
            int maxZ = minZ + 16;
            if (!this.claimService.isClaim(world.getChunkAt(chunk.getX(), chunk.getZ() - 1))) {
                for (x = minX; x <= maxX; ++x) {
                    points.add(new Location(world, (double)x, (double)(world.getHighestBlockYAt(x, minZ) + 1), (double)minZ));
                }
            }
            if (!this.claimService.isClaim(world.getChunkAt(chunk.getX(), chunk.getZ() + 1))) {
                for (x = minX; x <= maxX; ++x) {
                    points.add(new Location(world, (double)x, (double)(world.getHighestBlockYAt(x, maxZ) + 1), (double)maxZ));
                }
            }
            if (!this.claimService.isClaim(world.getChunkAt(chunk.getX() - 1, chunk.getZ()))) {
                for (z = minZ; z <= maxZ; ++z) {
                    points.add(new Location(world, (double)minX, (double)(world.getHighestBlockYAt(minX, z) + 1), (double)z));
                }
            }
            if (this.claimService.isClaim(world.getChunkAt(chunk.getX() + 1, chunk.getZ()))) continue;
            for (z = minZ; z <= maxZ; ++z) {
                points.add(new Location(world, (double)maxX, (double)(world.getHighestBlockYAt(maxX, z) + 1), (double)z));
            }
        }
        return new BorderData(color, points);
    }
}

