/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.listeners;

import com.huskydreaming.settlements.SettlementPlugin;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Member;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class MemberListener
implements Listener {
    private final BorderService borderService;
    private final ClaimService claimService;
    private final MemberService memberService;
    private final TrustService trustService;

    public MemberListener(SettlementPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.trustService = plugin.provide(TrustService.class);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        if (member != null) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date today = Calendar.getInstance().getTime();
            String lastOnline = df.format(today);
            member.setLastOnline(lastOnline);
            if (this.claimService.isClaim(player.getLocation().getChunk())) {
                String claim = this.claimService.getClaim(event.getPlayer().getLocation().getChunk());
                if (claim.equalsIgnoreCase(member.getSettlement())) {
                    this.borderService.addPlayer(player, claim, Color.AQUA);
                } else if (this.trustService.getOfflinePlayers(claim).contains(player)) {
                    this.borderService.addPlayer(player, claim, Color.YELLOW);
                } else {
                    this.borderService.addPlayer(player, claim, Color.RED);
                }
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        if (member != null) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date today = Calendar.getInstance().getTime();
            String lastOnline = df.format(today);
            member.setLastOnline(lastOnline);
            this.borderService.removePlayer(player);
        }
    }
}

