/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.listeners;

import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.settlements.SettlementPlugin;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.DependencyService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.NotificationService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class LandListener
implements Listener {
    private final BorderService borderService;
    private final ConfigService configService;
    private final ClaimService claimService;
    private final DependencyService dependencyService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final NotificationService notificationService;
    private final SettlementService settlementService;
    private final TrustService trustService;

    public LandListener(SettlementPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.dependencyService = plugin.provide(DependencyService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.notificationService = plugin.provide(NotificationService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.trustService = plugin.provide(TrustService.class);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getTo() != null && !event.getTo().getChunk().equals(event.getFrom().getChunk())) {
            this.sendChunkChange(event.getFrom().getChunk(), event.getTo().getChunk(), event.getPlayer());
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getTo() != null && !event.getTo().getChunk().equals(event.getFrom().getChunk())) {
            this.sendChunkChange(event.getFrom().getChunk(), event.getTo().getChunk(), event.getPlayer());
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Block block;
        if (event.getAction() != Action.PHYSICAL && (block = event.getClickedBlock()) != null) {
            Chunk chunk = block.getChunk();
            Player player = event.getPlayer();
            event.setCancelled(this.isCancelled(chunk, player, RolePermission.CLAIM_INTERACT));
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getChunk();
        event.setCancelled(this.isCancelled(chunk, player, RolePermission.CLAIM_BREAK));
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getChunk();
        event.setCancelled(this.isCancelled(chunk, player, RolePermission.CLAIM_PLACE));
    }

    private void handleChunkChange(Player player, String toChunk) {
        List<OfflinePlayer> offlinePlayers;
        Settlement settlement = this.settlementService.getSettlement(toChunk);
        if (settlement == null) {
            return;
        }
        if (this.trustService.hasTrusts((OfflinePlayer)player) && (offlinePlayers = this.trustService.getOfflinePlayers(toChunk)).contains(player)) {
            this.borderService.addPlayer(player, toChunk, Color.YELLOW);
            this.notificationService.sendTrust(player, toChunk, settlement.getDescription());
            return;
        }
        boolean isClaim = false;
        if (this.memberService.hasSettlement((OfflinePlayer)player)) {
            Member member = this.memberService.getCitizen((OfflinePlayer)player);
            isClaim = member.getSettlement().equalsIgnoreCase(toChunk);
        }
        this.borderService.removePlayer(player);
        this.borderService.addPlayer(player, toChunk, isClaim ? Color.AQUA : Color.RED);
        this.notificationService.sendSettlement(player, toChunk, settlement.getDescription(), isClaim);
    }

    private boolean hasAutoClaimedChunk(Player player, Chunk chunk) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            return false;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        if (!member.hasAutoClaim()) {
            return false;
        }
        Config config = this.configService.getConfig();
        if (config.containsDisableWorld(player.getWorld())) {
            player.sendMessage(Locale.SETTLEMENT_LAND_DISABLED_WORLD.prefix(new Object[0]));
            return false;
        }
        if (this.dependencyService.isTowny(player)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_TOWNY.prefix(new Object[0]));
            return false;
        }
        if (this.dependencyService.isWorldGuard(player)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_WORLDGUARD.prefix(new Object[0]));
            return false;
        }
        Set<ChunkData> chunks = this.claimService.getClaims(member.getSettlement());
        if (chunks.size() >= config.getSettlementDefault(SettlementDefaultType.MAX_CLAIMS)) {
            player.sendMessage(Locale.SETTLEMENT_AUTO_CLAIM_OFF_MAX_LAND.prefix(new Object[0]));
            member.setAutoClaim(false);
            return false;
        }
        this.claimService.setClaim(chunk, member.getSettlement());
        this.borderService.removePlayer(player);
        this.borderService.addPlayer(player, member.getSettlement(), Color.AQUA);
        player.sendMessage(Locale.SETTLEMENT_LAND_CLAIM.prefix(chunk.getX(), chunk.getZ()));
        return true;
    }

    private boolean isCancelled(Block block, Player player) {
        Chunk chunk = block.getChunk();
        if (!this.claimService.isClaim(chunk)) {
            return false;
        }
        if (this.dependencyService.isTowny(player, block)) {
            return false;
        }
        return !this.dependencyService.isWorldGuard(block);
    }

    private void sendChunkChange(Chunk from, Chunk to, Player player) {
        String fromChunk = this.claimService.getClaim(from);
        String toChunk = this.claimService.getClaim(to);
        if (fromChunk == null && toChunk != null) {
            this.handleChunkChange(player, toChunk);
            return;
        }
        if (toChunk != null && !fromChunk.equalsIgnoreCase(toChunk)) {
            this.handleChunkChange(player, toChunk);
            return;
        }
        if (toChunk == null && fromChunk != null) {
            if (this.hasAutoClaimedChunk(player, to)) {
                return;
            }
            this.borderService.removePlayer(player);
            this.notificationService.sendWilderness(player);
        }
    }

    private boolean isCancelled(Chunk chunk, Player player, RolePermission rolePermission) {
        String currentSettlement;
        Member member;
        String memberSettlement;
        if (!this.claimService.isClaim(chunk)) {
            return false;
        }
        if (this.memberService.hasSettlement((OfflinePlayer)player) && (memberSettlement = (member = this.memberService.getCitizen((OfflinePlayer)player)).getSettlement()).equalsIgnoreCase(currentSettlement = this.claimService.getClaim(chunk))) {
            Settlement settlement = this.settlementService.getSettlement(memberSettlement);
            Role role = this.roleService.getRole(member);
            if (this.dependencyService.isWorldGuard(player)) {
                return true;
            }
            if (this.dependencyService.isTowny(player)) {
                return true;
            }
            return !role.hasPermission(rolePermission) && !settlement.isOwner((OfflinePlayer)player);
        }
        return true;
    }
}

