/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.listeners;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.settlements.enumeration.Flag;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class FlagListener
implements Listener {
    private final ClaimService claimService;
    private final FlagService flagService;

    public FlagListener(HuskyPlugin plugin) {
        this.claimService = plugin.provide(ClaimService.class);
        this.flagService = plugin.provide(FlagService.class);
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent event) {
        String settlement;
        Chunk chunk = event.getLocation().getChunk();
        if (event.getEntity() instanceof Animals && this.claimService.isClaim(chunk)) {
            settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.ANIMAL_SPAWNING));
        }
        if (event.getEntity() instanceof Monster && this.claimService.isClaim(chunk)) {
            settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.MONSTER_SPAWNING));
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Chunk chunk;
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && this.claimService.isClaim(chunk = event.getFrom().getChunk())) {
            String settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.END_PORTAL));
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && event.getTo() != null && this.claimService.isClaim(chunk = event.getTo().getChunk())) {
            String settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.ENDER_PEARL));
        }
    }

    @EventHandler
    public void onPvP(EntityDamageByEntityEvent event) {
        Player player;
        Chunk chunk;
        Entity entity;
        if (event.getDamager() instanceof Player && (entity = event.getEntity()) instanceof Player && this.claimService.isClaim(chunk = (player = (Player)entity).getLocation().getChunk())) {
            String settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.PVP));
        }
    }

    @EventHandler
    public void onAnimalDamage(EntityDamageByEntityEvent event) {
        Animals animals;
        Chunk chunk;
        Entity entity;
        if (event.getDamager() instanceof Player && (entity = event.getEntity()) instanceof Animals && this.claimService.isClaim(chunk = (animals = (Animals)entity).getLocation().getChunk())) {
            String settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.ANIMAL_KILLING));
        }
    }

    @EventHandler
    public void onLeafDecay(LeavesDecayEvent event) {
        if (this.claimService.isClaim(event.getBlock().getChunk())) {
            String settlement = this.claimService.getClaim(event.getBlock().getChunk());
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.LEAF_DECAY));
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Chunk chunk = event.getLocation().getChunk();
        if (this.claimService.isClaim(chunk)) {
            String settlement = this.claimService.getClaim(chunk);
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.EXPLOSIONS));
            return;
        }
        for (Block block : event.blockList()) {
            if (!this.claimService.isClaim(block.getChunk())) continue;
            String settlement = this.claimService.getClaim(block.getChunk());
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.EXPLOSIONS));
            break;
        }
    }

    @EventHandler
    public void onLavaSpread(BlockFromToEvent event) {
        Material material = event.getBlock().getType();
        if ((material == Material.LAVA || material == Material.WATER) && this.claimService.isClaim(event.getToBlock().getChunk())) {
            String settlement = this.claimService.getClaim(event.getBlock().getChunk());
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.LAVA_SPREAD));
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        if (this.claimService.isClaim(event.getBlock().getChunk())) {
            String settlement = this.claimService.getClaim(event.getBlock().getChunk());
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.EXPLOSIONS));
            return;
        }
        for (Block block : event.blockList()) {
            if (!this.claimService.isClaim(block.getChunk())) continue;
            String settlement = this.claimService.getClaim(block.getChunk());
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.EXPLOSIONS));
            break;
        }
    }

    @EventHandler
    public void onLavaSpread(BlockSpreadEvent event) {
        Material material = event.getBlock().getType();
        if ((material == Material.LAVA || material == Material.WATER) && this.claimService.isClaim(event.getBlock().getChunk())) {
            String settlement = this.claimService.getClaim(event.getBlock().getChunk());
            event.setCancelled(!this.flagService.hasFlag(settlement, Flag.LAVA_SPREAD));
        }
    }
}

