/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.providers;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryPageProvider;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.content.InventoryContents;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class RolesInventory
extends InventoryPageProvider<Role> {
    private final HuskyPlugin plugin;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final SettlementService settlementService;
    private final RoleService roleService;

    public RolesInventory(HuskyPlugin plugin, int rows, Role[] roles) {
        super(rows, roles);
        this.plugin = plugin;
        this.memberService = plugin.provide(MemberService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.roleService = plugin.provide(RoleService.class);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        super.init(player, contents);
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getMainInventory(this.plugin, player)));
    }

    @Override
    public ItemStack construct(Player player, int index, Role role) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.closeInventory();
            return null;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Role memberRole = this.roleService.getRole(member);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        boolean isDefault = settlement.getDefaultRole().equalsIgnoreCase(role.getName());
        Material material = isDefault ? Material.BOOK : Material.PAPER;
        String defaultRole = isDefault ? Menu.SETTLEMENT_ROLE_EDIT_DEFAULT.parse() : "";
        List<String> lore = Menu.SETTLEMENT_ROLE_EDIT_LORE.parameterizeList(new Object[0]);
        if (memberRole.hasPermission(RolePermission.EDIT_ROLES) || settlement.isOwner((OfflinePlayer)player)) {
            lore.add("");
            lore.add(Menu.SETTLEMENT_ROLE_EDIT_CLICK.parse());
        }
        return ItemBuilder.create().setDisplayName(Menu.SETTLEMENT_ROLE_EDIT_TITLE.parameterize(index, role.getName(), defaultRole)).setMaterial(material).setEnchanted(isDefault).setAmount(index).setLore(lore).build();
    }

    @Override
    public void run(InventoryClickEvent event, Role role, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            Member member = this.memberService.getCitizen((OfflinePlayer)player);
            Role memberRole = this.roleService.getRole(member);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            if (!memberRole.hasPermission(RolePermission.EDIT_ROLES) && !settlement.isOwner((OfflinePlayer)player)) {
                return;
            }
            this.inventoryService.getRoleInventory(this.plugin, player, role).open(player);
        }
    }
}

