/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.providers;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryPageProvider;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.content.InventoryContents;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class RoleInventory
extends InventoryPageProvider<RolePermission> {
    private final HuskyPlugin plugin;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final SettlementService settlementService;
    private final RoleService roleService;
    private final Role role;

    public RoleInventory(HuskyPlugin plugin, int rows, Role role, RolePermission[] permissions) {
        super(rows, permissions);
        this.plugin = plugin;
        this.inventoryService = plugin.provide(InventoryService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.role = role;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        super.init(player, contents);
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getRolesInventory(this.plugin, player)));
        contents.set(0, 1, this.defaultItem(player, settlement));
        contents.set(0, 2, this.deleteItem(player, settlement, member.getSettlement()));
    }

    @Override
    public ItemStack construct(Player player, int index, RolePermission rolePermission) {
        return InventoryItem.of(this.role.hasPermission(rolePermission), rolePermission.toString(), rolePermission.getDescription());
    }

    @Override
    public void run(InventoryClickEvent event, RolePermission rolePermission, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            if (this.role.hasPermission(rolePermission)) {
                this.role.remove(rolePermission);
            } else {
                this.role.add(rolePermission);
            }
            contents.inventory().open(player);
        }
    }

    private ClickableItem deleteItem(Player player, Settlement settlement, String name) {
        return ClickableItem.of(ItemBuilder.create().setDisplayName(Menu.ROLE_DELETE_TITLE.parse()).setLore(Menu.ROLE_DELETE_LORE.parseList()).setMaterial(Material.TNT_MINECART).build(), e -> {
            if (this.roleService.getRoles(name).size() > 1) {
                if (settlement.getDefaultRole().equalsIgnoreCase(this.role.getName())) {
                    Role defaultRole = this.roleService.getOtherRole(name, this.role.getName());
                    settlement.setDefaultRole(defaultRole.getName());
                }
                this.memberService.sync(name, settlement.getDefaultRole(), this.role);
                this.roleService.remove(name, this.role);
                this.inventoryService.getRolesInventory(this.plugin, player).open(player);
            } else {
                player.sendMessage(Locale.ROLE_ONE.prefix(new Object[0]));
                player.closeInventory();
            }
        });
    }

    private ClickableItem defaultItem(Player player, Settlement settlement) {
        return ClickableItem.of(ItemBuilder.create().setDisplayName(Menu.ROLE_DEFAULT_TITLE.parse()).setLore(Menu.ROLE_DEFAULT_LORE.parseList()).setMaterial(Material.DIAMOND).build(), e -> {
            settlement.setDefaultRole(this.role.getName());
            this.inventoryService.getRolesInventory(this.plugin, player).open(player);
        });
    }
}

