/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.providers;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryPageProvider;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.filters.MemberFilter;
import com.huskydreaming.settlements.inventories.actions.UnTrustInventoryAction;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.content.InventoryContents;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MembersInventory
extends InventoryPageProvider<OfflinePlayer> {
    private final HuskyPlugin plugin;
    private final ConfigService configService;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final TrustService trustService;
    private MemberFilter memberFilter;

    public MembersInventory(HuskyPlugin plugin, int rows, OfflinePlayer[] offlinePlayers) {
        super(rows, offlinePlayers);
        this.plugin = plugin;
        this.configService = plugin.provide(ConfigService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.trustService = plugin.provide(TrustService.class);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        super.init(player, contents);
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getMainInventory(this.plugin, player)));
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        List<OfflinePlayer> offlinePlayers = this.trustService.getOfflinePlayers(member.getSettlement());
        if (!this.configService.getConfig().isTrusting() || offlinePlayers.isEmpty()) {
            return;
        }
        ChatColor chatColor = switch (this.memberFilter) {
            default -> throw new IncompatibleClassChangeError();
            case MemberFilter.TRUSTED -> ChatColor.YELLOW;
            case MemberFilter.MEMBER -> ChatColor.AQUA;
            case MemberFilter.ALL -> ChatColor.GREEN;
        };
        ItemStack itemStack = InventoryItem.of(chatColor, this.memberFilter.name());
        Consumer<InventoryClickEvent> consumer = e -> {
            MemberFilter newMemberFilter = switch (this.memberFilter) {
                default -> throw new IncompatibleClassChangeError();
                case MemberFilter.ALL -> MemberFilter.MEMBER;
                case MemberFilter.MEMBER -> MemberFilter.TRUSTED;
                case MemberFilter.TRUSTED -> MemberFilter.ALL;
            };
            this.inventoryService.getMembersInventory(this.plugin, player, newMemberFilter).open(player);
        };
        contents.set(0, 1, ClickableItem.of(itemStack, consumer));
    }

    @Override
    public ItemStack construct(Player player, int index, OfflinePlayer offlinePlayer) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.closeInventory();
            return null;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Role role = this.roleService.getRole(member);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        if (this.memberService.hasSettlement(offlinePlayer)) {
            Member offlineMember = this.memberService.getCitizen(offlinePlayer);
            Member onlineMember = this.memberService.getCitizen((OfflinePlayer)player);
            if (onlineMember.getSettlement().equalsIgnoreCase(offlineMember.getSettlement())) {
                boolean editable = role.hasPermission(RolePermission.EDIT_MEMBERS) || settlement.isOwner((OfflinePlayer)player);
                return this.memberItem(offlinePlayer, offlineMember, editable, index);
            }
        }
        boolean permission = role.hasPermission(RolePermission.MEMBER_TRUST) || settlement.isOwner((OfflinePlayer)player);
        return this.trustedItem(offlinePlayer, permission, index);
    }

    private ItemStack trustedItem(OfflinePlayer offlinePlayer, boolean permission, int index) {
        List<String> lore = Menu.TRUSTED_LORE.parameterizeList(new Object[0]);
        ItemBuilder itemBuilder = ItemBuilder.create().setDisplayName(Menu.TRUSTED_TITLE.parameterize(index, offlinePlayer.getName()));
        if (permission) {
            lore.add("");
            lore.add(Menu.TRUSTED_LORE_REMOVE.parse());
        }
        return itemBuilder.build();
    }

    private ItemStack memberItem(OfflinePlayer offlinePlayer, Member member, boolean editable, int index) {
        String online = Menu.MEMBERS_STATUS_ONLINE.parse();
        String offline = Menu.MEMBERS_STATUS_OFFLINE.parse();
        String status = offlinePlayer.isOnline() ? online : offline;
        String zone = ZoneId.systemDefault().getDisplayName(TextStyle.SHORT, Locale.getDefault());
        String lastOnline = (offlinePlayer.isOnline() ? "Now" : member.getLastOnline()) + " (" + zone + ")";
        List<String> lore = Menu.MEMBERS_LORE.parameterizeList(member.getRole(), status, lastOnline);
        if (editable) {
            lore.add("");
            lore.add(Menu.MEMBERS_LORE_EDIT.parse());
        }
        return ItemBuilder.create().setDisplayName(Menu.MEMBERS_TITLE.parameterize(index, offlinePlayer.getName())).setLore(lore).buildPlayer(offlinePlayer);
    }

    @Override
    public void run(InventoryClickEvent event, OfflinePlayer offlinePlayer, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Member offlineMember;
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            Member onlineMember = this.memberService.getCitizen((OfflinePlayer)player);
            Role role = this.roleService.getRole(onlineMember);
            Settlement settlement = this.settlementService.getSettlement(onlineMember.getSettlement());
            if (!role.hasPermission(RolePermission.EDIT_MEMBERS) && !settlement.isOwner((OfflinePlayer)player)) {
                return;
            }
            if (this.memberService.hasSettlement(offlinePlayer) && (offlineMember = this.memberService.getCitizen(offlinePlayer)).getSettlement().equalsIgnoreCase(onlineMember.getSettlement())) {
                this.inventoryService.getMemberInventory(this.plugin, offlinePlayer).open(player);
                return;
            }
            this.inventoryService.addAction(player, new UnTrustInventoryAction(this.plugin, onlineMember.getSettlement(), offlinePlayer));
            this.inventoryService.getConfirmationInventory(this.plugin, player).open(player);
        }
    }

    public void setMemberFilter(MemberFilter memberFilter) {
        this.memberFilter = memberFilter;
    }
}

