/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.providers;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.filters.MemberFilter;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MemberInventory
implements InventoryProvider {
    private final HuskyPlugin plugin;
    private final ConfigService configService;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final OfflinePlayer offlinePlayer;

    public MemberInventory(HuskyPlugin plugin, OfflinePlayer offlinePlayer) {
        this.plugin = plugin;
        this.configService = plugin.provide(ConfigService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.offlinePlayer = offlinePlayer;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        contents.fillBorders(InventoryItem.border());
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getMembersInventory(this.plugin, player, MemberFilter.ALL)));
        contents.set(1, 3, this.setOwner(settlement, contents));
        contents.set(1, 4, this.roleItem(contents));
        contents.set(1, 5, this.kickItem(contents));
        Config config = this.configService.getConfig();
        if (config.isTeleportation() && this.offlinePlayer.isOnline() && this.offlinePlayer.getPlayer() != player) {
            contents.set(1, 1, this.teleportItem(player));
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    private ClickableItem setOwner(Settlement settlement, InventoryContents contents) {
        return ClickableItem.of(ItemBuilder.create().setDisplayName(Menu.MEMBER_SET_OWNER_TITLE.parse()).setLore(Menu.MEMBER_SET_OWNER_LORE.parameterizeList(settlement.getOwnerName())).setMaterial(Material.EMERALD).build(), e -> this.setOwnerClick((InventoryClickEvent)e, contents));
    }

    private void setOwnerClick(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            if (!this.memberService.hasSettlement(this.offlinePlayer)) {
                return;
            }
            Member member = this.memberService.getCitizen(this.offlinePlayer);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            if (settlement.isOwner((OfflinePlayer)player)) {
                if (this.offlinePlayer.getUniqueId().equals(player.getUniqueId())) {
                    player.sendMessage(Locale.SETTLEMENT_IS_OWNER.prefix(new Object[0]));
                } else {
                    Player target = this.offlinePlayer.getPlayer();
                    if (target != null) {
                        target.sendMessage(Locale.SETTLEMENT_OWNER.prefix(new Object[0]));
                    }
                    player.sendMessage(Locale.SETTLEMENT_OWNER_TRANSFERRED.prefix(this.offlinePlayer.getName()));
                    settlement.setOwner(this.offlinePlayer);
                }
            } else {
                player.sendMessage(Locale.SETTLEMENT_NOT_OWNER_TRANSFER.prefix(new Object[0]));
            }
            contents.inventory().close(player);
        }
    }

    private ClickableItem teleportItem(Player player) {
        return ClickableItem.of(ItemBuilder.create().setDisplayName(Menu.MEMBER_TELEPORT_TITLE.parse()).setLore(Menu.MEMBER_TELEPORT_LORE.parseList()).setMaterial(Material.ENDER_PEARL).build(), e -> {
            Player onlinePlayer = this.offlinePlayer.getPlayer();
            if (onlinePlayer != null) {
                player.teleport((Entity)onlinePlayer);
                player.sendMessage(Locale.PLAYER_TELEPORT.prefix(this.offlinePlayer.getName()));
            }
        });
    }

    private ClickableItem roleItem(InventoryContents contents) {
        Member member = this.memberService.getCitizen(this.offlinePlayer);
        int index = this.roleService.getIndex(member.getSettlement(), member);
        return ClickableItem.of(ItemBuilder.create().setDisplayName(Menu.MEMBER_SET_ROLE_TITLE.parse()).setLore(Menu.MEMBER_SET_ROLE_LORE.parameterizeList(index, member.getRole())).setMaterial(Material.WRITABLE_BOOK).build(), e -> this.roleItemClick((InventoryClickEvent)e, contents));
    }

    private void roleItemClick(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            if (!this.memberService.hasSettlement(this.offlinePlayer)) {
                return;
            }
            Member member = this.memberService.getCitizen(this.offlinePlayer);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            Role role = this.roleService.sync(member, settlement.getDefaultRole());
            if (event.isRightClick()) {
                if (this.roleService.demote(member.getSettlement(), role, member)) {
                    contents.inventory().open(player);
                }
            } else if (event.isLeftClick() && this.roleService.promote(member.getSettlement(), role, member)) {
                contents.inventory().open(player);
            }
        }
    }

    private ClickableItem kickItem(InventoryContents contents) {
        return ClickableItem.of(ItemBuilder.create().setDisplayName(Menu.MEMBER_KICK_TITLE.parse()).setLore(Menu.MEMBER_KICK_LORE.parseList()).setMaterial(Material.ANVIL).build(), e -> this.kickItemClick((InventoryClickEvent)e, contents));
    }

    private void kickItemClick(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            if (!this.memberService.hasSettlement(this.offlinePlayer)) {
                return;
            }
            Member member = this.memberService.getCitizen(this.offlinePlayer);
            Role role = this.roleService.getRole(member);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            if (settlement.isOwner(this.offlinePlayer) || role.hasPermission(RolePermission.MEMBER_KICK_EXEMPT)) {
                player.sendMessage(Locale.SETTLEMENT_KICK_EXEMPT.prefix(new Object[0]));
            } else {
                player.sendMessage(Locale.SETTLEMENT_KICK_PLAYER.prefix(this.offlinePlayer.getName()));
                Player target = this.offlinePlayer.getPlayer();
                if (target != null) {
                    target.sendMessage(Locale.SETTLEMENT_KICK.prefix(member.getSettlement()));
                }
                this.memberService.remove(this.offlinePlayer);
            }
            contents.inventory().close(player);
        }
    }
}

