/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.providers;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryPageProvider;
import com.huskydreaming.settlements.enumeration.Flag;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import fr.minuskube.inv.content.InventoryContents;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class FlagsInventory
extends InventoryPageProvider<Flag> {
    private final HuskyPlugin plugin;
    private final FlagService flagService;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public FlagsInventory(HuskyPlugin plugin, int rows, Flag[] flags) {
        super(rows, flags);
        this.plugin = plugin;
        this.flagService = plugin.provide(FlagService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        super.init(player, contents);
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getMainInventory(this.plugin, player)));
    }

    @Override
    public ItemStack construct(Player player, int i, Flag flag) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.closeInventory();
            return null;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Role role = this.roleService.getRole(member);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        boolean enabled = this.flagService.hasFlag(member.getSettlement(), flag);
        if (!role.hasPermission(RolePermission.EDIT_FLAGS) && !settlement.isOwner((OfflinePlayer)player)) {
            return InventoryItem.of(enabled, false, flag.toString(), flag.getDescription());
        }
        return InventoryItem.of(enabled, flag.toString(), flag.getDescription());
    }

    @Override
    public void run(InventoryClickEvent event, Flag flag, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            Member member = this.memberService.getCitizen((OfflinePlayer)player);
            Role role = this.roleService.getRole(member);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            if (!role.hasPermission(RolePermission.EDIT_FLAGS) && !settlement.isOwner((OfflinePlayer)player)) {
                return;
            }
            boolean enabled = this.flagService.hasFlag(member.getSettlement(), flag);
            if (enabled) {
                this.flagService.removeFlag(member.getSettlement(), flag);
            } else {
                this.flagService.addFlag(member.getSettlement(), flag);
            }
            contents.inventory().open(player);
        }
    }
}

