/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.providers;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryPageProvider;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.content.InventoryContents;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ClaimsInventory
extends InventoryPageProvider<ChunkData> {
    private final HuskyPlugin plugin;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final boolean teleportation;

    public ClaimsInventory(HuskyPlugin plugin, int rows, ChunkData[] chunks) {
        super(rows, chunks);
        this.plugin = plugin;
        ConfigService configService = plugin.provide(ConfigService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.teleportation = configService.getConfig().isTeleportation();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        super.init(player, contents);
        contents.set(0, 0, InventoryItem.back(player, this.inventoryService.getMainInventory(this.plugin, player)));
    }

    @Override
    public ItemStack construct(Player player, int i, ChunkData data) {
        ItemBuilder builder = ItemBuilder.create().setDisplayName(Menu.CLAIMS_TITLE.parameterize(data.getX(), data.getZ())).setMaterial(Material.GRASS_BLOCK);
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Role role = this.roleService.getRole(member);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        if (this.teleportation && (role.hasPermission(RolePermission.CLAIM_TELEPORT) || settlement.isOwner((OfflinePlayer)player))) {
            builder.setLore(Menu.CLAIMS_LORE.parameterizeList(data.getWorld()));
        }
        return builder.build();
    }

    @Override
    public void run(InventoryClickEvent event, ChunkData data, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (event.isLeftClick() && this.teleportation) {
                Chunk chunk = data.toChunk();
                World world = chunk.getWorld();
                int x = (chunk.getX() << 4) + 8;
                int z = (chunk.getZ() << 4) + 8;
                int y = world.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING_NO_LEAVES);
                Location location = new Location(world, (double)x, (double)(y + 1), (double)z);
                player.teleport(location);
                player.sendMessage(Locale.SETTLEMENT_TELEPORT.prefix(x, z));
            }
        }
    }
}

