/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.modules.general;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Menu;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InformationModule
implements InventoryModule {
    private final ClaimService claimService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public InformationModule(HuskyPlugin plugin) {
        this.claimService = plugin.provide(ClaimService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public ItemStack itemStack(Player player) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.closeInventory();
            return null;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        int members = this.memberService.getMembers(member.getSettlement()).size();
        int claims = this.claimService.getClaims(member.getSettlement()).size();
        int roles = this.roleService.getRoles(member.getSettlement()).size();
        return ItemBuilder.create().setMaterial(Material.CHEST).setDisplayName(Menu.SETTLEMENT_INFO_TITLE.parse()).setLore(Menu.SETTLEMENT_INFO_LORE.parameterizeList(settlement.getDescription(), settlement.getOwnerName(), members, settlement.getMaxCitizens(), claims, settlement.getMaxLand(), roles, settlement.getMaxRoles())).build();
    }
}

