/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.modules.general;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.HomeService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.content.InventoryContents;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class HomeModule
implements InventoryModule {
    private final HuskyPlugin plugin;
    private final ConfigService configService;
    private final HomeService homeService;
    private final InventoryService inventoryService;
    private final MemberService memberService;

    public HomeModule(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.configService = plugin.provide(ConfigService.class);
        this.homeService = plugin.provide(HomeService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.memberService = plugin.provide(MemberService.class);
    }

    @Override
    public ItemStack itemStack(Player player) {
        return ItemBuilder.create().setDisplayName(Menu.SETTLEMENT_HOMES_TITLE.parse()).setLore(Menu.SETTLEMENT_HOMES_LORE.parseList()).setMaterial(Material.WHITE_BED).build();
    }

    @Override
    public void run(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
                return;
            }
            Member member = this.memberService.getCitizen((OfflinePlayer)player);
            if (!this.homeService.hasHomes(member.getSettlement())) {
                return;
            }
            this.inventoryService.getHomesInventory(this.plugin, player).open(player);
        }
    }

    @Override
    public boolean isValid(Player player) {
        return this.configService.getConfig().isHomes();
    }
}

