/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.modules.admin;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import com.huskydreaming.huskycore.registries.CommandRegistry;
import com.huskydreaming.settlements.commands.subcommands.SetSpawnCommand;
import com.huskydreaming.settlements.commands.subcommands.SpawnCommand;
import com.huskydreaming.settlements.enumeration.types.ConfigType;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.storage.persistence.Config;
import fr.minuskube.inv.content.InventoryContents;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AdminTeleportationModule
implements InventoryModule {
    private final HuskyPlugin plugin;
    private final ConfigService configService;
    private final CommandRegistry commandRegistry;

    public AdminTeleportationModule(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.configService = plugin.provide(ConfigService.class);
        this.commandRegistry = plugin.getCommandRegistry();
    }

    @Override
    public ItemStack itemStack(Player player) {
        Config config = this.configService.getConfig();
        ConfigType configType = ConfigType.TELEPORTATION;
        return InventoryItem.of(config.isTeleportation(), configType.toString(), configType.getDescription());
    }

    @Override
    public void run(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            Config config = this.configService.getConfig();
            if (config.isTeleportation()) {
                config.setTeleportation(false);
                this.commandRegistry.remove("spawn");
                this.commandRegistry.remove("setspawn");
            } else {
                config.setTeleportation(true);
                this.commandRegistry.add(new SpawnCommand(this.plugin));
                this.commandRegistry.add(new SetSpawnCommand(this.plugin));
            }
            contents.inventory().open(player);
        }
    }
}

