/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.modules.admin;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.types.NotificationType;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.content.InventoryContents;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AdminNotificationModule
implements InventoryModule {
    private final ConfigService configService;

    public AdminNotificationModule(HuskyPlugin plugin) {
        this.configService = plugin.provide(ConfigService.class);
    }

    @Override
    public ItemStack itemStack(Player player) {
        Config config = this.configService.getConfig();
        NotificationType notificationType = config.getNotificationType();
        Material material = switch (notificationType) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationType.NONE -> Material.BARRIER;
            case NotificationType.ACTION_BAR -> Material.BOOK;
            case NotificationType.BOSS_BAR -> Material.WRITABLE_BOOK;
            case NotificationType.TITLE -> Material.PAPER;
        };
        return ItemBuilder.create().setDisplayName(Menu.ADMIN_NOTIFICATION_TITLE.parse()).setLore(Menu.ADMIN_NOTIFICATION_LORE.parameterizeList(notificationType.toString())).setMaterial(material).build();
    }

    @Override
    public void run(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            Config config = this.configService.getConfig();
            NotificationType notificationType = config.getNotificationType();
            List<NotificationType> notificationTypes = List.of(NotificationType.values());
            int index = notificationTypes.indexOf((Object)notificationType);
            index = index < notificationTypes.size() - 1 ? ++index : 0;
            config.setNotificationType(notificationTypes.get(index));
            contents.inventory().open(player);
        }
    }
}

