/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.modules.admin;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import com.huskydreaming.huskycore.utilities.ItemBuilder;
import com.huskydreaming.settlements.enumeration.types.ConfigType;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.storage.types.Menu;
import fr.minuskube.inv.content.InventoryContents;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AdminDisabledWorldsModule
implements InventoryModule {
    private final HuskyPlugin plugin;
    private final InventoryService inventoryService;

    public AdminDisabledWorldsModule(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.inventoryService = plugin.provide(InventoryService.class);
    }

    @Override
    public ItemStack itemStack(Player player) {
        ConfigType configType = ConfigType.DISABLED_WORLDS;
        return ItemBuilder.create().setDisplayName(Menu.ADMIN_DISABLED_WORLDS_TITLE.parse()).setLore(Menu.ADMIN_DISABLED_WORLDS_LORE.parameterizeList(configType.getDescription())).setMaterial(Material.GRASS_BLOCK).build();
    }

    @Override
    public void run(InventoryClickEvent event, InventoryContents contents) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            this.inventoryService.getWorldsInventory(this.plugin).open(player);
        }
    }
}

