/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.inventories.actions;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.settlements.inventories.base.InventoryAction;
import com.huskydreaming.settlements.inventories.base.InventoryActionType;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.types.Locale;
import org.bukkit.entity.Player;

public class DisbandInventoryAction
implements InventoryAction {
    private final BorderService borderService;
    private final FlagService flagService;
    private final MemberService memberService;
    private final ClaimService claimService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final TrustService trustService;
    private final String settlement;

    public DisbandInventoryAction(HuskyPlugin plugin, String settlement) {
        this.borderService = plugin.provide(BorderService.class);
        this.flagService = plugin.provide(FlagService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.trustService = plugin.provide(TrustService.class);
        this.settlement = settlement;
    }

    @Override
    public InventoryActionType getType() {
        return InventoryActionType.DISBAND;
    }

    @Override
    public void onAccept(Player player) {
        this.claimService.clean(this.settlement);
        this.memberService.clean(this.settlement);
        this.flagService.clean(this.settlement);
        this.roleService.clean(this.settlement);
        this.trustService.clean(this.settlement);
        this.settlementService.disbandSettlement(this.settlement);
        this.borderService.removePlayer(player);
        player.closeInventory();
        player.sendMessage(Locale.SETTLEMENT_DISBAND_YES.prefix(new Object[0]));
    }

    @Override
    public void onDeny(Player player) {
        player.closeInventory();
        player.sendMessage(Locale.SETTLEMENT_DISBAND_NO.prefix(new Object[0]));
    }
}

