/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.dependencies;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.enumeration.Placeholder;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettlementPlaceholderExpansion
extends PlaceholderExpansion {
    private final HuskyPlugin plugin;
    private final ClaimService claimService;
    private final ConfigService configService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public SettlementPlaceholderExpansion(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.configService = plugin.provide(ConfigService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getDescription().getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        String[] split;
        if (Placeholder.NAME.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            return this.memberService.getCitizen(player).getSettlement();
        }
        if (Placeholder.TAG.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            Config config = this.configService.getConfig();
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            String tag = settlement.getTag();
            return tag == null ? config.getEmptyPlaceholder() : tag;
        }
        if (Placeholder.OWNER.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            return settlement.getOwnerName();
        }
        if (Placeholder.CLAIMS_COUNT.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            Set<ChunkData> chunks = this.claimService.getClaims(member.getSettlement());
            return String.valueOf(chunks.size());
        }
        if (Placeholder.ROLES_COUNT.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            List<Role> roles = this.roleService.getRoles(member.getSettlement());
            return String.valueOf(roles.size());
        }
        if (Placeholder.MEMBERS_COUNT.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            List<Member> members = this.memberService.getMembers(member.getSettlement());
            return String.valueOf(members.size());
        }
        if (Placeholder.CLAIMS_MAX.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            return String.valueOf(settlement.getMaxLand());
        }
        if (Placeholder.ROLES_MAX.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            return String.valueOf(settlement.getMaxRoles());
        }
        if (Placeholder.MEMBERS_MAX.isPlaceholder(params) && this.memberService.hasSettlement(player)) {
            Member member = this.memberService.getCitizen(player);
            Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
            return String.valueOf(settlement.getMaxCitizens());
        }
        Config config = this.configService.getConfig();
        String defaultString = config.getEmptyPlaceholder();
        if (Placeholder.MEMBERS_TOP.containsPlaceholder(params) && (split = params.split("_")).length == 3 && Util.isNumeric(split[2])) {
            int number = Integer.parseInt(split[2]);
            if (this.memberService.getCount() < number) {
                return defaultString;
            }
            LinkedHashMap<String, Long> map = this.memberService.getTop(number);
            if (map.isEmpty()) {
                return defaultString;
            }
            String last = null;
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                last = key = iterator.next();
            }
            return last;
        }
        if (Placeholder.CLAIMS_TOP.containsPlaceholder(params) && (split = params.split("_")).length == 3 && Util.isNumeric(split[2])) {
            int number = Integer.parseInt(split[2]);
            if (this.claimService.getCount() < number) {
                return defaultString;
            }
            LinkedHashMap<String, Long> map = this.claimService.getTop(number);
            if (map.isEmpty()) {
                return defaultString;
            }
            String last = null;
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                last = key = iterator.next();
            }
            return last;
        }
        return defaultString;
    }
}

