/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="unclaim")
public class UnClaimCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final MemberService memberService;
    private final ClaimService claimService;
    private final ConfigService configService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public UnClaimCommand(HuskyPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        if (this.configService.isDisabledWorld(player)) {
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.CLAIM_LAND) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        Chunk chunk = player.getLocation().getChunk();
        String claim = this.claimService.getClaim(chunk);
        if (claim == null) {
            player.sendMessage(Locale.SETTLEMENT_LAND_NOT_CLAIMED.prefix(new Object[0]));
            return;
        }
        if (this.claimService.getClaims(member.getSettlement()).size() == 1) {
            player.sendMessage(Locale.SETTLEMENT_LAND_UNCLAIM_ONE.prefix(new Object[0]));
            return;
        }
        if (member.getSettlement().equalsIgnoreCase(claim)) {
            this.claimService.removeClaim(chunk);
            this.borderService.removePlayer(player);
            player.sendMessage(Locale.SETTLEMENT_LAND_UNCLAIM.prefix(new Object[0]));
            return;
        }
        player.sendMessage(Locale.SETTLEMENT_LAND_CLAIMED.prefix(new Object[0]));
    }
}

