/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="trust")
public class TrustCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final ClaimService claimService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final TrustService trustService;

    public TrustCommand(HuskyPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.trustService = plugin.provide(TrustService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        Set<String> trustedSettlements;
        Member offlineMember;
        if (strings.length != 2) {
            return;
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.MEMBER_TRUST) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        String string = strings[1];
        OfflinePlayer offlinePlayer = Util.getOfflinePlayer(string);
        if (offlinePlayer == null) {
            player.sendMessage(Locale.PLAYER_NULL.prefix(string));
            return;
        }
        if (offlinePlayer.isOnline() && offlinePlayer.getPlayer() == player) {
            player.sendMessage(Locale.SETTLEMENT_TRUST_SELF.prefix(new Object[0]));
            return;
        }
        if (this.memberService.hasSettlement(offlinePlayer) && (offlineMember = this.memberService.getCitizen(offlinePlayer)).getSettlement().equalsIgnoreCase(member.getSettlement())) {
            player.sendMessage(Locale.SETTLEMENT_IS_MEMBER.prefix(offlinePlayer.getName()));
            return;
        }
        if (this.trustService.hasTrusts(offlinePlayer) && (trustedSettlements = this.trustService.getSettlements(offlinePlayer)) != null && trustedSettlements.contains(member.getSettlement())) {
            player.sendMessage(Locale.SETTLEMENT_IS_TRUSTED.prefix(offlinePlayer.getName()));
            return;
        }
        this.trustService.trust(offlinePlayer, member.getSettlement());
        player.sendMessage(Locale.SETTLEMENT_TRUST.prefix(offlinePlayer.getName()));
        if (!offlinePlayer.isOnline()) {
            return;
        }
        Player target = offlinePlayer.getPlayer();
        if (target == null) {
            return;
        }
        target.sendMessage(Locale.SETTLEMENT_TRUST_OFFLINE_PLAYER.prefix(member.getSettlement()));
        Chunk chunk = player.getLocation().getChunk();
        if (!this.claimService.isClaim(chunk)) {
            return;
        }
        String settlementName = this.claimService.getClaim(chunk);
        if (!this.trustService.getOfflinePlayers(settlementName).contains(offlinePlayer)) {
            return;
        }
        this.borderService.addPlayer(target, settlementName, Color.YELLOW);
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length == 2 && this.memberService.hasSettlement((OfflinePlayer)player)) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return List.of();
    }
}

