/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="setowner", arguments={" [player]"})
public class SetOwnerCommand
implements PlayerCommandProvider {
    private final MemberService memberService;
    private final SettlementService settlementService;

    public SetOwnerCommand(HuskyPlugin plugin) {
        this.memberService = plugin.provide(MemberService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        String string = strings[1];
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        if (!settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_NOT_OWNER.prefix(new Object[0]));
            return;
        }
        OfflinePlayer offlinePlayer = Util.getOfflinePlayer(string);
        if (offlinePlayer == null) {
            player.sendMessage(Locale.PLAYER_NULL.prefix(string));
            return;
        }
        if (offlinePlayer.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(Locale.SETTLEMENT_IS_OWNER.prefix(new Object[0]));
            return;
        }
        Member offlineMember = this.memberService.getCitizen(offlinePlayer);
        if (!offlineMember.getSettlement().equalsIgnoreCase(member.getSettlement())) {
            player.sendMessage(Locale.SETTLEMENT_NOT_CITIZEN.prefix(new Object[0]));
            return;
        }
        settlement.setOwner(offlinePlayer);
        player.sendMessage(Locale.SETTLEMENT_OWNER_TRANSFERRED.prefix(offlinePlayer.getName()));
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        Member member;
        Settlement settlement;
        if (strings.length == 2 && this.memberService.hasSettlement((OfflinePlayer)player) && (settlement = this.settlementService.getSettlement((member = this.memberService.getCitizen((OfflinePlayer)player)).getSettlement())).isOwner((OfflinePlayer)player)) {
            return this.memberService.getOfflinePlayers(member.getSettlement()).stream().map(OfflinePlayer::getName).toList();
        }
        return List.of();
    }
}

