/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.CommandProvider;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import com.huskydreaming.settlements.services.interfaces.LocaleService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.types.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@CommandAnnotation(label="reload")
public class ReloadCommand
implements CommandProvider {
    private final HuskyPlugin plugin;
    private final ClaimService claimService;
    private final ConfigService configService;
    private final FlagService flagService;
    private final LocaleService localeService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public ReloadCommand(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.claimService = plugin.provide(ClaimService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.flagService = plugin.provide(FlagService.class);
        this.localeService = plugin.provide(LocaleService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(CommandSender sender, String[] strings) {
        this.localeService.getLocale().reload((Plugin)this.plugin);
        this.localeService.getMenu().reload((Plugin)this.plugin);
        this.claimService.serialize(this.plugin);
        this.configService.deserialize(this.plugin);
        this.flagService.serialize(this.plugin);
        this.memberService.serialize(this.plugin);
        this.roleService.serialize(this.plugin);
        this.settlementService.serialize(this.plugin);
        sender.sendMessage(Locale.RELOAD.prefix(new Object[0]));
    }
}

