/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.SettlementPlugin;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.types.Locale;
import org.bukkit.entity.Player;

@CommandAnnotation(label="list")
public class ListCommand
implements PlayerCommandProvider {
    private final SettlementPlugin plugin;
    private final InventoryService inventoryService;
    private final SettlementService settlementService;

    public ListCommand(SettlementPlugin plugin) {
        this.plugin = plugin;
        this.inventoryService = plugin.provide(InventoryService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 1) {
            return;
        }
        if (this.settlementService.getSettlements().isEmpty()) {
            player.sendMessage(Locale.SETTLEMENT_LIST_NULL.prefix(new Object[0]));
            return;
        }
        this.inventoryService.getSettlementsInventory(this.plugin).open(player);
    }
}

