/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.SettlementPlugin;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="leave")
public class LeaveCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final MemberService memberService;
    private final SettlementService settlementService;

    public LeaveCommand(SettlementPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        if (settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_LEAVE_OWNER.prefix(new Object[0]));
            return;
        }
        this.memberService.remove((OfflinePlayer)player);
        this.borderService.removePlayer(player);
        this.borderService.addPlayer(player, member.getSettlement(), Color.RED);
        player.sendMessage(Locale.SETTLEMENT_LEAVE.prefix(new Object[0]));
        List<OfflinePlayer> offlinePlayers = this.memberService.getOfflinePlayers(member.getSettlement());
        for (OfflinePlayer offlinePlayer : offlinePlayers) {
            if (!offlinePlayer.isOnline()) {
                return;
            }
            Player onlinePlayer = offlinePlayer.getPlayer();
            if (onlinePlayer == null) {
                return;
            }
            onlinePlayer.sendMessage(Locale.SETTLEMENT_LEAVE_PLAYER.prefix(player.getName()));
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length == 1 && this.memberService.hasSettlement((OfflinePlayer)player)) {
            Member member = this.memberService.getCitizen((OfflinePlayer)player);
            return List.of(member.getSettlement());
        }
        return List.of();
    }
}

