/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.SettlementPlugin;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="kick", arguments={" [player]"})
public class KickCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public KickCommand(SettlementPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        String string = strings[1];
        OfflinePlayer offlinePlayer = Util.getOfflinePlayer(string);
        if (offlinePlayer == null) {
            player.sendMessage(Locale.PLAYER_NULL.prefix(string));
            return;
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.MEMBER_KICK) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        Member offlineMember = this.memberService.getCitizen(offlinePlayer);
        Role offlineRole = this.roleService.getRole(offlineMember);
        if (offlineRole.hasPermission(RolePermission.MEMBER_KICK_EXEMPT) || settlement.isOwner(offlinePlayer)) {
            player.sendMessage(Locale.SETTLEMENT_KICK_EXEMPT.prefix(new Object[0]));
            return;
        }
        this.memberService.remove(offlinePlayer);
        Player onlinePlayer = offlinePlayer.getPlayer();
        if (onlinePlayer != null) {
            onlinePlayer.closeInventory();
            this.borderService.removePlayer(onlinePlayer);
            this.borderService.addPlayer(onlinePlayer, member.getSettlement(), Color.RED);
            onlinePlayer.sendMessage(Locale.SETTLEMENT_KICK.parameterize(member.getSettlement()));
        }
        for (OfflinePlayer offline : this.memberService.getOfflinePlayers(member.getSettlement())) {
            if (!offline.isOnline()) {
                return;
            }
            Player on = offline.getPlayer();
            if (on == null) {
                return;
            }
            on.sendMessage(Locale.SETTLEMENT_LEAVE_PLAYER.prefix(offlinePlayer.getName()));
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length == 2 && this.memberService.hasSettlement((OfflinePlayer)player)) {
            Member member = this.memberService.getCitizen((OfflinePlayer)player);
            return this.memberService.getOfflinePlayers(member.getSettlement()).stream().map(OfflinePlayer::getName).toList();
        }
        return List.of();
    }
}

