/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.InvitationService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="invite", arguments={" [Player]"})
public class InviteCommand
implements PlayerCommandProvider {
    private final MemberService memberService;
    private final InvitationService invitationService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public InviteCommand(HuskyPlugin plugin) {
        this.memberService = plugin.provide(MemberService.class);
        this.invitationService = plugin.provide(InvitationService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Player target = Bukkit.getPlayer((String)strings[1]);
        if (target == null) {
            player.sendMessage(Locale.PLAYER_OFFLINE.prefix(strings[1]));
            return;
        }
        if (target == player) {
            player.sendMessage(Locale.INVITATION_SELF.prefix(new Object[0]));
            return;
        }
        if (this.memberService.hasSettlement((OfflinePlayer)target)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_HAS_SETTLEMENT.prefix(target.getName()));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.MEMBER_INVITE) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        target.sendMessage(Locale.INVITATION_RECEIVED.prefix(member.getSettlement()));
        this.invitationService.sendInvitation(target, member.getSettlement());
        player.sendMessage(Locale.INVITATION_SENT.prefix(target.getName()));
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }
        return List.of();
    }
}

