/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.interfaces.Command;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.registries.CommandRegistry;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

@CommandAnnotation(label="help", arguments={" [page]"})
public class HelpCommand
implements PlayerCommandProvider {
    private final CommandRegistry commandRegistry;

    public HelpCommand(HuskyPlugin plugin) {
        this.commandRegistry = plugin.getCommandRegistry();
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        Set<Command> subCommands;
        int page;
        int index = 1;
        if (strings.length > 1 && Util.isNumeric(strings[1])) {
            index = Integer.parseInt(strings[1]);
            if (strings[1].equals("0")) {
                index = 1;
            }
        }
        if (index > (page = (int)Math.ceil((double)(subCommands = this.commandRegistry.getCommands()).size() / 6.0))) {
            player.sendMessage(Locale.HELP_PAGE_LIMIT.prefix(page));
            return;
        }
        for (int i = 0; i < 10; ++i) {
            player.sendMessage("");
        }
        player.sendMessage(Locale.HELP_PAGE_HEADER.parameterize(index, page));
        player.sendMessage("");
        ArrayList stringList = new ArrayList();
        subCommands.forEach(command -> stringList.add("/settlements " + command.getLabel().toLowerCase() + Arrays.toString(command.getArguments())));
        Collections.sort(stringList);
        for (int i = 0; i < stringList.size() && i < 5; ++i) {
            int number = i + (index - 1) * 5;
            if (number >= stringList.size()) {
                player.sendMessage("");
                continue;
            }
            String string = (String)stringList.get(number);
            TextComponent message = new TextComponent(Locale.HELP_PAGE_FORMAT.parameterize(number + 1, string));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, string));
            player.spigot().sendMessage((BaseComponent)message);
        }
        player.sendMessage("");
        TextComponent next = new TextComponent(Locale.HELP_PAGE_NEXT.parse());
        TextComponent previous = new TextComponent(Locale.HELP_PAGE_PREVIOUS.parse());
        TextComponent spacer = new TextComponent("            ");
        if (index == 1) {
            previous.setText(Locale.HELP_PAGE_DISABLED.parse() + previous.getText());
            next.setText(Locale.HELP_PAGE_ENABLED.parse() + next.getText());
            next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/s help " + (index + 1)));
        } else if (index + 1 > page) {
            next.setText(Locale.HELP_PAGE_DISABLED.parse() + next.getText());
            previous.setText(Locale.HELP_PAGE_ENABLED.parse() + previous.getText());
            previous.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/s help " + (index - 1)));
        } else {
            next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/s help " + (index + 1)));
            next.setText(Locale.HELP_PAGE_ENABLED.parse() + next.getText());
            previous.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/s help " + (index - 1)));
            previous.setText(Locale.HELP_PAGE_ENABLED.parse() + previous.getText());
        }
        player.spigot().sendMessage(new BaseComponent[]{spacer, previous, spacer, next, spacer});
        player.sendMessage("");
    }
}

