/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.services.interfaces.InvitationService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;

@CommandAnnotation(label="deny", arguments={" [settlement]"})
public class DenyCommand
implements PlayerCommandProvider {
    private final InvitationService invitationService;
    private final SettlementService settlementService;

    public DenyCommand(HuskyPlugin plugin) {
        this.invitationService = plugin.provide(InvitationService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        String string = strings[1];
        if (this.invitationService.hasNoInvitation(player, string)) {
            player.sendMessage(Locale.INVITATION_NULL.prefix(string));
            return;
        }
        Settlement settlement = this.settlementService.getSettlement(string);
        if (settlement == null) {
            player.sendMessage(Locale.SETTLEMENT_NULL.prefix(string));
            return;
        }
        this.invitationService.removeInvitation(player, strings[1]);
        player.sendMessage(Locale.INVITATION_DENIED.prefix(string));
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        Set<String> invitations;
        if (strings.length == 2 && (invitations = this.invitationService.getInvitations(player)) != null) {
            return invitations.stream().toList();
        }
        return List.of();
    }
}

