/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="deleterole", arguments={" [role]"})
public class DeleteRoleCommand
implements PlayerCommandProvider {
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public DeleteRoleCommand(HuskyPlugin plugin) {
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.EDIT_ROLES) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        String roleName = strings[1];
        if (!this.roleService.hasRole(member.getSettlement(), roleName)) {
            player.sendMessage(Locale.ROLE_NULL.prefix(roleName));
            return;
        }
        Role roleToDelete = this.roleService.getRole(member.getSettlement(), roleName);
        this.roleService.remove(member.getSettlement(), roleToDelete);
        player.sendMessage(Locale.ROLE_DELETE.prefix(roleName));
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length != 2 || !this.memberService.hasSettlement((OfflinePlayer)player)) {
            return new ArrayList<String>();
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        return this.roleService.getRoles(member.getSettlement()).stream().map(Role::getName).collect(Collectors.toList());
    }
}

