/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.services.interfaces.HomeService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Home;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="deletehome")
public class DeleteHomeCommand
implements PlayerCommandProvider {
    private final HomeService homeService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public DeleteHomeCommand(HuskyPlugin plugin) {
        this.homeService = plugin.provide(HomeService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Role role = this.roleService.getRole(member);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        if (!role.hasPermission(RolePermission.EDIT_HOMES) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        String home = strings[1];
        if (!this.homeService.hasHome(member.getSettlement(), home)) {
            player.sendMessage(Locale.HOME_NULL.prefix(Util.capitalize(home)));
            return;
        }
        this.homeService.deleteHome(member.getSettlement(), home);
        player.sendMessage(Locale.HOME_DELETE.prefix(home));
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length != 2) {
            return List.of();
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            return List.of();
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        return this.homeService.getHomes(member.getSettlement()).stream().map(Home::name).collect(Collectors.toList());
    }
}

