/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.DependencyService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

@CommandAnnotation(label="create", arguments={" [name]"})
public class CreateCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final ClaimService claimService;
    private final ConfigService configService;
    private final DependencyService dependencyService;
    private final FlagService flagService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public CreateCommand(HuskyPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.dependencyService = plugin.provide(DependencyService.class);
        this.flagService = plugin.provide(FlagService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 2) {
            return;
        }
        if (this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_EXISTS.prefix(new Object[0]));
            return;
        }
        if (this.configService.isDisabledWorld(player)) {
            return;
        }
        if (this.dependencyService.isTowny(player)) {
            return;
        }
        String name = strings[1].toLowerCase();
        Config config = this.configService.getConfig();
        int minimumNameLength = config.getSettlementDefault(SettlementDefaultType.MIN_NAME_LENGTH);
        int maximumNameLength = config.getSettlementDefault(SettlementDefaultType.MAX_NAME_LENGTH);
        if (this.settlementService.isSettlement(name)) {
            player.sendMessage(Locale.SETTLEMENT_EXIST.prefix(new Object[0]));
            return;
        }
        if (name.length() < minimumNameLength) {
            player.sendMessage(Locale.SETTLEMENT_CREATE_MIN_NAME_LENGTH.prefix(minimumNameLength));
            return;
        }
        if (name.length() > maximumNameLength) {
            player.sendMessage(Locale.SETTLEMENT_CREATE_MAX_NAME_LENGTH.prefix(maximumNameLength));
            return;
        }
        World world = player.getWorld();
        if (config.containsDisableWorld(world) || world.getEnvironment() != World.Environment.NORMAL) {
            player.sendMessage(Locale.SETTLEMENT_CREATE_DISABLED_WORLD.prefix(new Object[0]));
            return;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (this.claimService.isClaim(chunk)) {
            player.sendMessage(Locale.SETTLEMENT_ESTABLISHED.prefix(new Object[0]));
            return;
        }
        if (this.claimService.isAdjacentToExistingClaim(chunk)) {
            player.sendMessage(Locale.SETTLEMENT_ESTABLISHED_ADJACENT.prefix(new Object[0]));
            return;
        }
        Settlement settlement = this.settlementService.createSettlement(player, name);
        this.flagService.setup(name);
        this.roleService.setup(name, settlement);
        this.claimService.setClaim(chunk, name);
        this.memberService.add((OfflinePlayer)player, name, settlement.getDefaultRole());
        this.borderService.addPlayer(player, name, Color.AQUA);
        player.sendMessage(Locale.SETTLEMENT_CREATED.prefix(name));
    }
}

