/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.DependencyService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="claim")
public class ClaimCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final ClaimService claimService;
    private final ConfigService configService;
    private final DependencyService dependencyService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public ClaimCommand(HuskyPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.dependencyService = plugin.provide(DependencyService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        if (this.configService.isDisabledWorld(player)) {
            return;
        }
        if (this.dependencyService.isDependency(player)) {
            return;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (this.claimService.isClaim(chunk)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_CLAIMED.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.CLAIM_LAND) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        Set<ChunkData> chunks = this.claimService.getClaims(member.getSettlement());
        Config config = this.configService.getConfig();
        if (chunks.size() >= config.getSettlementDefault(SettlementDefaultType.MAX_CLAIMS)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_CLAIMED_MAX.prefix(settlement.getMaxLand()));
            return;
        }
        if (this.claimService.isAdjacentToOtherClaim(member.getSettlement(), chunk)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_ADJACENT_OTHER.prefix(new Object[0]));
            return;
        }
        if (!this.claimService.isAdjacent(member.getSettlement(), chunk)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_ADJACENT.prefix(new Object[0]));
            return;
        }
        String x = String.valueOf(chunk.getX());
        String z = String.valueOf(chunk.getZ());
        player.sendMessage(Locale.SETTLEMENT_LAND_CLAIM.prefix(x, z));
        this.claimService.setClaim(chunk, member.getSettlement());
        this.borderService.addPlayer(player, member.getSettlement(), Color.AQUA);
    }
}

