/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.settlements.enumeration.RolePermission;
import com.huskydreaming.settlements.enumeration.types.SettlementDefaultType;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.storage.persistence.Config;
import com.huskydreaming.settlements.storage.persistence.Member;
import com.huskydreaming.settlements.storage.persistence.Role;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="autoclaim")
public class AutoClaimCommand
implements PlayerCommandProvider {
    private final ClaimService claimService;
    private final ConfigService configService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;

    public AutoClaimCommand(HuskyPlugin plugin) {
        this.claimService = plugin.provide(ClaimService.class);
        this.configService = plugin.provide(ConfigService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.settlementService = plugin.provide(SettlementService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length != 1) {
            return;
        }
        if (this.configService.isDisabledWorld(player)) {
            return;
        }
        if (!this.memberService.hasSettlement((OfflinePlayer)player)) {
            player.sendMessage(Locale.SETTLEMENT_PLAYER_NULL.prefix(new Object[0]));
            return;
        }
        Member member = this.memberService.getCitizen((OfflinePlayer)player);
        Settlement settlement = this.settlementService.getSettlement(member.getSettlement());
        Role role = this.roleService.getRole(member);
        if (!role.hasPermission(RolePermission.CLAIM_LAND) && !settlement.isOwner((OfflinePlayer)player)) {
            player.sendMessage(Locale.NO_PERMISSIONS.prefix(new Object[0]));
            return;
        }
        Set<ChunkData> chunks = this.claimService.getClaims(member.getSettlement());
        Config config = this.configService.getConfig();
        if (chunks.size() >= config.getSettlementDefault(SettlementDefaultType.MAX_CLAIMS)) {
            player.sendMessage(Locale.SETTLEMENT_AUTO_CLAIM_ON_MAX_LAND.prefix(new Object[0]));
            return;
        }
        boolean autoClaim = member.hasAutoClaim();
        Locale locale = autoClaim ? Locale.SETTLEMENT_AUTO_CLAIM_OFF : Locale.SETTLEMENT_AUTO_CLAIM_ON;
        player.sendMessage(locale.prefix(new Object[0]));
        member.setAutoClaim(!autoClaim);
    }
}

