/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.huskycore.utilities.Util;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;

@CommandAnnotation(label="admin", arguments={" [claim|disband|help|unclaim]"})
public class AdminCommand
implements PlayerCommandProvider {
    private final HuskyPlugin plugin;
    private final ClaimService claimService;
    private final FlagService flagService;
    private final InventoryService inventoryService;
    private final MemberService memberService;
    private final RoleService roleService;
    private final SettlementService settlementService;
    private final TrustService trustService;

    public AdminCommand(HuskyPlugin plugin) {
        this.plugin = plugin;
        this.claimService = plugin.provide(ClaimService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
        this.flagService = plugin.provide(FlagService.class);
        this.roleService = plugin.provide(RoleService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.trustService = plugin.provide(TrustService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        if (strings.length == 1) {
            this.inventoryService.getAdminInventory(player, this.plugin).open(player);
        } else if (strings.length == 2) {
            String string = strings[1].toUpperCase();
            if (string.equalsIgnoreCase("unclaim")) {
                this.sendUnClaim(player);
            } else if (string.equalsIgnoreCase("help")) {
                this.sendHelp(player);
            } else {
                this.sendUnknown(player, string);
            }
        } else if (strings.length == 3) {
            String string = strings[1].toUpperCase();
            if (string.equalsIgnoreCase("claim")) {
                this.sendClaim(player, strings[2]);
            } else if (string.equalsIgnoreCase("disband")) {
                this.sendDisband(player, strings[2]);
            } else {
                this.sendUnknown(player, string);
            }
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        if (strings.length == 2) {
            return List.of("claim", "disband", "help", "unclaim");
        }
        return List.of();
    }

    private void sendClaim(Player player, String string) {
        Chunk chunk = player.getLocation().getChunk();
        if (this.settlementService.isSettlement(string)) {
            boolean isAdjacent = false;
            for (ChunkData data : this.claimService.getClaims(string)) {
                if (!Util.areAdjacentChunks(chunk, data.toChunk())) continue;
                isAdjacent = true;
            }
            if (isAdjacent) {
                String x = String.valueOf(chunk.getX());
                String z = String.valueOf(chunk.getZ());
                player.sendMessage(Locale.SETTLEMENT_LAND_CLAIM.prefix(x, z));
                this.claimService.setClaim(chunk, string);
            } else {
                player.sendMessage(Locale.SETTLEMENT_LAND_ADJACENT.prefix(new Object[0]));
            }
        } else {
            player.sendMessage(Locale.SETTLEMENT_NULL.prefix(string));
        }
    }

    private void sendUnClaim(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        if (!this.claimService.isClaim(chunk)) {
            player.sendMessage(Locale.SETTLEMENT_LAND_NOT_CLAIMED.prefix(new Object[0]));
            return;
        }
        String claim = this.claimService.getClaim(chunk);
        if (this.claimService.getClaims(claim).size() == 1) {
            player.sendMessage(Locale.SETTLEMENT_LAND_UNCLAIM_ONE.prefix(new Object[0]));
        } else {
            this.claimService.removeClaim(chunk);
            player.sendMessage(Locale.SETTLEMENT_LAND_UNCLAIM.prefix(new Object[0]));
        }
    }

    private void sendDisband(Player player, String string) {
        if (!this.settlementService.isSettlement(string)) {
            player.sendMessage(Locale.SETTLEMENT_NULL.prefix(string));
            return;
        }
        this.claimService.clean(string);
        this.memberService.clean(string);
        this.flagService.clean(string);
        this.roleService.clean(string);
        this.trustService.clean(string);
        this.settlementService.disbandSettlement(string);
        player.sendMessage(Locale.SETTLEMENT_DISBAND_YES.prefix(new Object[0]));
    }

    private void sendUnknown(Player player, String string) {
        player.sendMessage(Locale.UNKNOWN_SUBCOMMAND.prefix(string));
    }

    private void sendHelp(Player player) {
        List<String> strings = Locale.ADMIN_HELP.parseList();
        if (strings == null) {
            return;
        }
        strings.stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
    }
}

