/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands.subcommands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.providers.PlayerCommandProvider;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.InvitationService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Settlement;
import com.huskydreaming.settlements.storage.types.Locale;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAnnotation(label="accept", arguments={" [settlement]"})
public class AcceptCommand
implements PlayerCommandProvider {
    private final BorderService borderService;
    private final ClaimService claimService;
    private final MemberService memberService;
    private final InvitationService invitationService;
    private final SettlementService settlementService;
    private final TrustService trustService;

    public AcceptCommand(HuskyPlugin plugin) {
        this.borderService = plugin.provide(BorderService.class);
        this.claimService = plugin.provide(ClaimService.class);
        this.memberService = plugin.provide(MemberService.class);
        this.invitationService = plugin.provide(InvitationService.class);
        this.settlementService = plugin.provide(SettlementService.class);
        this.trustService = plugin.provide(TrustService.class);
    }

    @Override
    public void onCommand(Player player, String[] strings) {
        String claim;
        if (strings.length != 2) {
            return;
        }
        String string = strings[1];
        if (this.invitationService.hasNoInvitation(player, string)) {
            player.sendMessage(Locale.INVITATION_NULL.prefix(string));
            return;
        }
        Settlement settlement = this.settlementService.getSettlement(string);
        if (settlement == null) {
            player.sendMessage(Locale.SETTLEMENT_NULL.prefix(string));
            return;
        }
        for (OfflinePlayer offlinePlayer : this.memberService.getOfflinePlayers(string)) {
            if (!offlinePlayer.isOnline()) {
                return;
            }
            Player onlinePlayer = offlinePlayer.getPlayer();
            if (onlinePlayer == null) {
                return;
            }
            onlinePlayer.sendMessage(Locale.SETTLEMENT_JOIN_PLAYER.prefix(player.getName()));
        }
        this.borderService.removePlayer(player);
        this.invitationService.removeInvitation(player, string);
        this.trustService.unTrust((OfflinePlayer)player, string);
        this.memberService.add((OfflinePlayer)player, string, settlement.getDefaultRole());
        player.sendMessage(Locale.SETTLEMENT_JOIN.prefix(string));
        Chunk chunk = player.getLocation().getChunk();
        if (!this.claimService.isClaim(chunk)) {
            return;
        }
        this.borderService.addPlayer(player, claim, (claim = this.claimService.getClaim(player.getLocation().getChunk())).equalsIgnoreCase(string) ? Color.AQUA : Color.RED);
    }

    @Override
    public List<String> onTabComplete(Player player, String[] strings) {
        Set<String> invitations;
        if (strings.length == 2 && (invitations = this.invitationService.getInvitations(player)) != null) {
            return invitations.stream().toList();
        }
        return List.of();
    }
}

