/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements.commands;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.CommandAnnotation;
import com.huskydreaming.huskycore.commands.abstraction.AbstractCommand;
import com.huskydreaming.huskycore.interfaces.Parseable;
import com.huskydreaming.settlements.commands.subcommands.HelpCommand;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.storage.types.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAnnotation(label="settlements")
public class BaseCommand
extends AbstractCommand {
    private final HuskyPlugin plugin;
    private final MemberService memberService;
    private final InventoryService inventoryService;

    public BaseCommand(HuskyPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
        this.memberService = plugin.provide(MemberService.class);
        this.inventoryService = plugin.provide(InventoryService.class);
    }

    @Override
    public Parseable getPermission() {
        return Locale.NO_PERMISSIONS;
    }

    @Override
    public Parseable getUsage() {
        return Locale.UNKNOWN_SUBCOMMAND;
    }

    @Override
    public void onCommand(CommandSender commandSender, String[] strings) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (this.memberService.hasSettlement((OfflinePlayer)player)) {
                this.inventoryService.getMainInventory(this.plugin, player).open(player);
            } else {
                new HelpCommand(this.plugin).onCommand(player, strings);
            }
        }
    }
}

