/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.settlements;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.settlements.commands.BaseCommand;
import com.huskydreaming.settlements.commands.subcommands.AcceptCommand;
import com.huskydreaming.settlements.commands.subcommands.AdminCommand;
import com.huskydreaming.settlements.commands.subcommands.AutoClaimCommand;
import com.huskydreaming.settlements.commands.subcommands.ClaimCommand;
import com.huskydreaming.settlements.commands.subcommands.CreateCommand;
import com.huskydreaming.settlements.commands.subcommands.CreateRoleCommand;
import com.huskydreaming.settlements.commands.subcommands.DeleteHomeCommand;
import com.huskydreaming.settlements.commands.subcommands.DeleteRoleCommand;
import com.huskydreaming.settlements.commands.subcommands.DenyCommand;
import com.huskydreaming.settlements.commands.subcommands.DisbandCommand;
import com.huskydreaming.settlements.commands.subcommands.HelpCommand;
import com.huskydreaming.settlements.commands.subcommands.HomeCommand;
import com.huskydreaming.settlements.commands.subcommands.InviteCommand;
import com.huskydreaming.settlements.commands.subcommands.KickCommand;
import com.huskydreaming.settlements.commands.subcommands.LeaveCommand;
import com.huskydreaming.settlements.commands.subcommands.ListCommand;
import com.huskydreaming.settlements.commands.subcommands.ReloadCommand;
import com.huskydreaming.settlements.commands.subcommands.SetDescriptionCommand;
import com.huskydreaming.settlements.commands.subcommands.SetHomeCommand;
import com.huskydreaming.settlements.commands.subcommands.SetOwnerCommand;
import com.huskydreaming.settlements.commands.subcommands.SetSpawnCommand;
import com.huskydreaming.settlements.commands.subcommands.SetTagCommand;
import com.huskydreaming.settlements.commands.subcommands.SpawnCommand;
import com.huskydreaming.settlements.commands.subcommands.TrustCommand;
import com.huskydreaming.settlements.commands.subcommands.UnClaimCommand;
import com.huskydreaming.settlements.commands.subcommands.UnTrustCommand;
import com.huskydreaming.settlements.listeners.FlagListener;
import com.huskydreaming.settlements.listeners.LandListener;
import com.huskydreaming.settlements.listeners.MemberListener;
import com.huskydreaming.settlements.services.implementations.BorderServiceImpl;
import com.huskydreaming.settlements.services.implementations.ClaimServiceImpl;
import com.huskydreaming.settlements.services.implementations.ConfigServiceImpl;
import com.huskydreaming.settlements.services.implementations.DependencyServiceImpl;
import com.huskydreaming.settlements.services.implementations.FlagServiceImpl;
import com.huskydreaming.settlements.services.implementations.HomeServiceImpl;
import com.huskydreaming.settlements.services.implementations.InventoryServiceImpl;
import com.huskydreaming.settlements.services.implementations.InvitationServiceImpl;
import com.huskydreaming.settlements.services.implementations.LocaleServiceImpl;
import com.huskydreaming.settlements.services.implementations.MemberServiceImpl;
import com.huskydreaming.settlements.services.implementations.NotificationServiceImpl;
import com.huskydreaming.settlements.services.implementations.RoleServiceImpl;
import com.huskydreaming.settlements.services.implementations.SettlementServiceImpl;
import com.huskydreaming.settlements.services.implementations.TrustServiceImpl;
import com.huskydreaming.settlements.services.interfaces.BorderService;
import com.huskydreaming.settlements.services.interfaces.ClaimService;
import com.huskydreaming.settlements.services.interfaces.ConfigService;
import com.huskydreaming.settlements.services.interfaces.DependencyService;
import com.huskydreaming.settlements.services.interfaces.FlagService;
import com.huskydreaming.settlements.services.interfaces.HomeService;
import com.huskydreaming.settlements.services.interfaces.InventoryService;
import com.huskydreaming.settlements.services.interfaces.InvitationService;
import com.huskydreaming.settlements.services.interfaces.LocaleService;
import com.huskydreaming.settlements.services.interfaces.MemberService;
import com.huskydreaming.settlements.services.interfaces.NotificationService;
import com.huskydreaming.settlements.services.interfaces.RoleService;
import com.huskydreaming.settlements.services.interfaces.SettlementService;
import com.huskydreaming.settlements.services.interfaces.TrustService;
import com.huskydreaming.settlements.storage.persistence.Config;

public class SettlementPlugin
extends HuskyPlugin {
    @Override
    public void onEnable() {
        super.onEnable();
        this.registerServices();
        this.registerCommands();
        this.registerListeners(new LandListener(this), new MemberListener(this), new FlagListener(this));
    }

    public void onDisable() {
        this.serviceRegistry.serialize(this);
    }

    private void registerServices() {
        this.serviceRegistry.register(LocaleService.class, new LocaleServiceImpl(this));
        this.serviceRegistry.register(ConfigService.class, new ConfigServiceImpl(this));
        this.serviceRegistry.register(DependencyService.class, new DependencyServiceImpl());
        this.serviceRegistry.register(HomeService.class, new HomeServiceImpl());
        this.serviceRegistry.register(MemberService.class, new MemberServiceImpl());
        this.serviceRegistry.register(SettlementService.class, new SettlementServiceImpl(this));
        this.serviceRegistry.register(FlagService.class, new FlagServiceImpl(this));
        this.serviceRegistry.register(NotificationService.class, new NotificationServiceImpl(this));
        this.serviceRegistry.register(InvitationService.class, new InvitationServiceImpl());
        this.serviceRegistry.register(RoleService.class, new RoleServiceImpl(this));
        this.serviceRegistry.register(TrustService.class, new TrustServiceImpl());
        this.serviceRegistry.register(ClaimService.class, new ClaimServiceImpl());
        this.serviceRegistry.register(BorderService.class, new BorderServiceImpl(this));
        this.serviceRegistry.register(InventoryService.class, new InventoryServiceImpl(this));
        this.serviceRegistry.deserialize(this);
    }

    private void registerCommands() {
        this.commandRegistry.setCommandExecutor(new BaseCommand(this));
        this.commandRegistry.add(new AcceptCommand(this));
        this.commandRegistry.add(new AdminCommand(this));
        this.commandRegistry.add(new AutoClaimCommand(this));
        this.commandRegistry.add(new ClaimCommand(this));
        this.commandRegistry.add(new CreateCommand(this));
        this.commandRegistry.add(new CreateRoleCommand(this));
        this.commandRegistry.add(new DeleteRoleCommand(this));
        this.commandRegistry.add(new DenyCommand(this));
        this.commandRegistry.add(new DisbandCommand(this));
        this.commandRegistry.add(new HelpCommand(this));
        this.commandRegistry.add(new InviteCommand(this));
        this.commandRegistry.add(new KickCommand(this));
        this.commandRegistry.add(new LeaveCommand(this));
        this.commandRegistry.add(new ListCommand(this));
        this.commandRegistry.add(new ReloadCommand(this));
        this.commandRegistry.add(new SetDescriptionCommand(this));
        this.commandRegistry.add(new SetOwnerCommand(this));
        this.commandRegistry.add(new SetTagCommand(this));
        ConfigService configService = this.serviceRegistry.provide(ConfigService.class);
        Config config = configService.getConfig();
        if (config.isTeleportation()) {
            this.commandRegistry.add(new SpawnCommand(this));
            this.commandRegistry.add(new SetSpawnCommand(this));
        }
        if (config.isTrusting()) {
            this.commandRegistry.add(new TrustCommand(this));
            this.commandRegistry.add(new UnTrustCommand(this));
        }
        if (config.isHomes()) {
            this.commandRegistry.add(new DeleteHomeCommand(this));
            this.commandRegistry.add(new HomeCommand(this));
            this.commandRegistry.add(new SetHomeCommand(this));
        }
        this.commandRegistry.add(new UnClaimCommand(this));
        this.commandRegistry.deserialize(this);
    }
}

