/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.storage;

import com.huskydreaming.huskycore.enumeration.Extension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Yaml {
    private final String name;
    private Path path;
    private FileConfiguration configuration;

    public Yaml(String name) {
        this.name = name;
    }

    public void load(Plugin plugin) {
        this.path = this.create(plugin, this.name);
        this.configuration = YamlConfiguration.loadConfiguration((File)this.path.toFile());
    }

    public void save() {
        if (this.configuration == null || this.path == null || !Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        try {
            this.configuration.save(this.path.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload(Plugin plugin) {
        this.configuration = YamlConfiguration.loadConfiguration((File)this.path.toFile());
        InputStream inputStream = plugin.getResource(this.getFileName());
        if (inputStream == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        YamlConfiguration defaultConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        this.configuration.setDefaults((Configuration)defaultConfiguration);
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }

    private Path create(Plugin plugin, String fileName) {
        Path path = Paths.get(plugin.getDataFolder() + File.separator + fileName + Extension.YAML, new String[0]);
        Path parentPath = path.getParent();
        try {
            if (!Files.exists(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
                plugin.getLogger().info("Created new directory: " + parentPath.getFileName());
            }
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
                plugin.getLogger().info("Created new file: " + path.getFileName());
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe(e.getMessage());
        }
        return path;
    }

    private String getFileName() {
        return this.name + ".yml";
    }
}

