/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.huskydreaming.huskycore.data.ChunkData;
import com.huskydreaming.huskycore.enumeration.Extension;
import com.huskydreaming.huskycore.serializers.ChunkSerializer;
import com.huskydreaming.huskycore.serializers.LocationSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class Json {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Location.class, (Object)new LocationSerializer()).registerTypeAdapter(ChunkData.class, (Object)new ChunkSerializer()).setPrettyPrinting().create();

    public static void write(Plugin plugin, String fileName, Object object) {
        Path path = Json.create(plugin, fileName, Extension.JSON);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(object, (Appendable)bufferedWriter);
        }
        catch (IOException e) {
            plugin.getLogger().severe(e.getMessage());
        }
    }

    public static <T> T read(Plugin plugin, String fileName, Type type) {
        BufferedReader bufferedReader;
        Path path = Json.create(plugin, fileName, Extension.JSON);
        try {
            bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        JsonReader jsonReader = new JsonReader((Reader)bufferedReader);
        try {
            return (T)GSON.fromJson(jsonReader, type);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    public static Path create(Plugin plugin, String fileName, Extension extension) {
        Path path = Paths.get(plugin.getDataFolder() + File.separator + fileName + extension.toString(), new String[0]);
        Path parentPath = path.getParent();
        try {
            if (!Files.exists(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
                plugin.getLogger().info("Created new directory: " + parentPath.getFileName());
            }
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
                plugin.getLogger().info("Created new file: " + path.getFileName());
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe(e.getMessage());
        }
        return path;
    }
}

