/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationSerializer
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    public Location deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        double x = jsonObject.get("x").getAsDouble();
        double y = jsonObject.get("y").getAsDouble();
        double z = jsonObject.get("z").getAsDouble();
        float pitch = jsonObject.get("pitch").getAsFloat();
        float yaw = jsonObject.get("yaw").getAsFloat();
        String worldId = jsonObject.get("worldId").getAsString();
        World world = null;
        if (worldId != null) {
            UUID worldID = UUID.fromString(worldId);
            world = Bukkit.getWorld((UUID)worldID);
        }
        return world == null ? null : new Location(world, x, y, z, pitch, yaw);
    }

    public JsonElement serialize(Location location, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("x", (Number)location.getX());
        jsonObject.addProperty("y", (Number)location.getY());
        jsonObject.addProperty("z", (Number)location.getZ());
        jsonObject.addProperty("pitch", (Number)Float.valueOf(location.getPitch()));
        jsonObject.addProperty("yaw", (Number)Float.valueOf(location.getYaw()));
        World world = location.getWorld();
        if (world != null) {
            jsonObject.addProperty("worldId", world.getUID().toString());
        }
        return jsonObject;
    }
}

