/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.registries;

import com.huskydreaming.huskycore.HuskyPlugin;
import com.huskydreaming.huskycore.commands.abstraction.AbstractCommand;
import com.huskydreaming.huskycore.commands.interfaces.Command;
import com.huskydreaming.huskycore.interfaces.Registry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;

public class CommandRegistry
implements Registry {
    private AbstractCommand abstractCommand;
    private final Set<Command> commands = new HashSet<Command>();

    @Override
    public void deserialize(HuskyPlugin plugin) {
        PluginCommand pluginCommand = plugin.getCommand(this.abstractCommand.getLabel());
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)this.abstractCommand);
        }
    }

    public void setCommandExecutor(AbstractCommand abstractCommand) {
        this.abstractCommand = abstractCommand;
    }

    public AbstractCommand getAbstractCommand() {
        return this.abstractCommand;
    }

    public Command getCommand(String string) {
        return this.commands.stream().filter(s -> s.getLabel().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public void add(Command command) {
        this.commands.add(command);
    }

    public void remove(String name) {
        this.commands.removeIf(subCommand -> subCommand.getLabel().equalsIgnoreCase(name));
    }

    public Set<Command> getCommands() {
        return Collections.unmodifiableSet(this.commands);
    }
}

