/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.inventories;

import com.huskydreaming.huskycore.inventories.InventoryItem;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import fr.minuskube.inv.content.SlotIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class InventoryPageProvider<E>
implements InventoryProvider {
    protected final int rows;
    protected boolean updates;
    protected E[] array;

    public InventoryPageProvider(int rows) {
        this.rows = rows;
    }

    public InventoryPageProvider(int rows, E[] array) {
        this.rows = rows;
        this.array = array;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(InventoryItem.border());
        this.setupItems(player, contents);
        this.setupPagination(player, contents);
    }

    @Override
    public void update(Player player, InventoryContents contents) {
        if (this.updates) {
            int state = contents.property("state", 0);
            contents.setProperty("state", state + 1);
            if (state % 20 != 0) {
                return;
            }
            this.setupItems(player, contents);
        }
    }

    public abstract ItemStack construct(Player var1, int var2, E var3);

    public abstract void run(InventoryClickEvent var1, E var2, InventoryContents var3);

    public void setArray(E[] array) {
        this.array = array;
    }

    private void setupPagination(Player player, InventoryContents contents) {
        Pagination pagination = contents.pagination();
        pagination.setItemsPerPage(Math.min(this.rows * 9, 27));
        pagination.addToIterator(contents.newIterator(SlotIterator.Type.HORIZONTAL, 1, 0));
        if (!pagination.isLast() && !pagination.isFirst()) {
            contents.set(4, 1, InventoryItem.previous(player, contents));
            contents.set(4, 7, InventoryItem.next(player, contents));
        }
        if (!pagination.isLast()) {
            contents.set(4, 7, InventoryItem.next(player, contents));
        }
        if (!pagination.isFirst()) {
            contents.set(4, 1, InventoryItem.previous(player, contents));
        }
        this.setupItems(player, contents);
    }

    public void setupItems(Player player, InventoryContents contents) {
        ClickableItem[] clickableItems = new ClickableItem[this.array.length];
        for (int i = 0; i < clickableItems.length; ++i) {
            AtomicInteger atomicInteger = new AtomicInteger(i);
            ItemStack itemStack = this.construct(player, i + 1, this.array[atomicInteger.get()]);
            Consumer<InventoryClickEvent> consumer = e -> this.run((InventoryClickEvent)e, this.array[atomicInteger.get()], contents);
            clickableItems[i] = ClickableItem.of(itemStack, consumer);
        }
        contents.pagination().setItems(clickableItems);
    }
}

