/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.inventories;

import com.huskydreaming.huskycore.inventories.InventoryItem;
import com.huskydreaming.huskycore.inventories.InventoryModule;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import fr.minuskube.inv.content.SlotIterator;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class InventoryModuleProvider
implements InventoryProvider {
    protected int rows;
    protected final List<InventoryModule> modules = new ArrayList<InventoryModule>();

    public void deserialize(Player player, InventoryModule ... modules) {
        int size = 0;
        for (InventoryModule module : modules) {
            if (!module.isValid(player)) continue;
            this.modules.add(module);
            ++size;
        }
        this.rows = (int)Math.ceil((double)size / 9.0);
    }

    public void deserialize(Player player, List<InventoryModule> modules) {
        int size = 0;
        for (InventoryModule module : modules) {
            if (!module.isValid(player)) continue;
            this.modules.add(module);
            ++size;
        }
        this.rows = (int)Math.ceil((double)size / 9.0);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(InventoryItem.border());
        ArrayList<ClickableItem> clickableItems = new ArrayList<ClickableItem>();
        for (InventoryModule module : this.modules) {
            ItemStack itemStack = module.itemStack(player);
            clickableItems.add(ClickableItem.of(itemStack, e -> module.run((InventoryClickEvent)e, contents)));
        }
        Pagination pagination = contents.pagination();
        pagination.setItems(clickableItems.toArray(new ClickableItem[0]));
        pagination.setItemsPerPage(Math.min(this.rows * 9, 27));
        pagination.addToIterator(contents.newIterator(SlotIterator.Type.HORIZONTAL, 1, 0));
        if (!pagination.isLast() && !pagination.isFirst()) {
            contents.set(4, 1, InventoryItem.previous(player, contents));
            contents.set(4, 7, InventoryItem.next(player, contents));
        }
        if (!pagination.isLast()) {
            contents.set(4, 7, InventoryItem.next(player, contents));
        }
        if (!pagination.isFirst()) {
            contents.set(4, 1, InventoryItem.previous(player, contents));
        }
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }

    public int getRows() {
        return this.rows;
    }
}

