/*
 * Decompiled with CFR 0.152.
 */
package com.huskydreaming.huskycore.data;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ChunkData {
    private final String world;
    private final int x;
    private final int z;

    public static ChunkData deserialize(String[] strings) {
        return new ChunkData(strings[0], Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
    }

    public static ChunkData deserialize(Chunk chunk) {
        return new ChunkData(chunk);
    }

    public ChunkData(String world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public ChunkData(Chunk chunk) {
        this.world = chunk.getWorld().getName();
        this.x = chunk.getX();
        this.z = chunk.getZ();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public Chunk toChunk() {
        World world = Bukkit.getWorld((String)this.world);
        if (world == null) {
            return null;
        }
        return world.getChunkAt(this.x, this.z);
    }

    public String toString() {
        return this.world + ":" + this.x + ":" + this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChunkData)) {
            return false;
        }
        ChunkData data = (ChunkData)o;
        return this.x == data.x && this.z == data.z && Objects.equals(this.world, data.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }
}

